/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import com.google.common.collect.Multimap;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.CombinedEntryAccessor;
import fzzyhmstrs.emi_loot.mixins.ConditionalLootFunctionAccessor;
import fzzyhmstrs.emi_loot.mixins.ItemEntryAccessor;
import fzzyhmstrs.emi_loot.mixins.LeafEntryAccessor;
import fzzyhmstrs.emi_loot.mixins.LootPoolAccessor;
import fzzyhmstrs.emi_loot.mixins.LootPoolEntryAccessor;
import fzzyhmstrs.emi_loot.mixins.LootTableEntryAccessor;
import fzzyhmstrs.emi_loot.mixins.RandomChanceLootConditionAccessor;
import fzzyhmstrs.emi_loot.mixins.TagEntryAccessor;
import fzzyhmstrs.emi_loot.parser.processor.NumberProcessors;
import fzzyhmstrs.emi_loot.parser.registry.LootParserRegistry;
import fzzyhmstrs.emi_loot.server.ArchaeologyLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.ArchaeologyLootTableSender;
import fzzyhmstrs.emi_loot.server.BlockLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.BlockLootTableSender;
import fzzyhmstrs.emi_loot.server.ChestLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.ChestLootTableSender;
import fzzyhmstrs.emi_loot.server.EmptyLootTableSender;
import fzzyhmstrs.emi_loot.server.GameplayLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.GameplayLootTableSender;
import fzzyhmstrs.emi_loot.server.LootBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import fzzyhmstrs.emi_loot.server.MobLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.MobLootTableSender;
import fzzyhmstrs.emi_loot.server.ServerResourceData;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.LootTablePools;
import fzzyhmstrs.emi_loot.util.SimpleFzzyPayload;
import fzzyhmstrs.emi_loot.util.TextKey;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.networking.FzzyPayload;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.EntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.SequentialEntry;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.Nullable;

public class LootTableParser {
    private static final Map<ResourceLocation, ChestLootTableSender> chestSenders = new HashMap<ResourceLocation, ChestLootTableSender>();
    private static final Map<ResourceLocation, BlockLootTableSender> blockSenders = new HashMap<ResourceLocation, BlockLootTableSender>();
    private static final Map<ResourceLocation, MobLootTableSender> mobSenders = new HashMap<ResourceLocation, MobLootTableSender>();
    private static final Map<ResourceLocation, GameplayLootTableSender> gameplaySenders = new HashMap<ResourceLocation, GameplayLootTableSender>();
    private static final Map<ResourceLocation, ArchaeologyLootTableSender> archaeologySenders = new HashMap<ResourceLocation, ArchaeologyLootTableSender>();
    public static final Object2BooleanMap<PostProcessor> postProcessors;
    private static Map<LootDataId<?>, ?> tables;
    private static final Map<ResourceLocation, LootDataId<?>> keyLookUp;
    public static String currentTable;
    public static List<ResourceLocation> parsedDirectDrops;
    public static boolean hasParsedLootTables;
    public static LootDataManager lootManager;
    public static final ResourceLocation CLEAR_LOOTS;

    private static boolean hasPostProcessed() {
        BooleanIterator booleanIterator = postProcessors.values().iterator();
        while (booleanIterator.hasNext()) {
            boolean bl = (Boolean)booleanIterator.next();
            if (bl) continue;
            return false;
        }
        return true;
    }

    public void registerServer(ServerPlayer player) {
        if (!LootTableParser.hasPostProcessed()) {
            EMILoot.LOGGER.warn("Post-processing not completed for some reason, completing now...");
            for (PostProcessor process : PostProcessor.values()) {
                LootTableParser.postProcess(process);
            }
            EMILoot.LOGGER.warn("Post-processing complete!");
        }
        if (ConfigApi.INSTANCE.network().canSend(CLEAR_LOOTS, (Player)player)) {
            ConfigApi.INSTANCE.network().send((FzzyPayload)new SimpleFzzyPayload(ConfigApi.INSTANCE.network().buf(), CLEAR_LOOTS), (Player)player);
        }
        if (EMILoot.config.parseChestLoot) {
            chestSenders.forEach((id, chestSender) -> chestSender.send(player));
        }
        if (EMILoot.config.parseBlockLoot) {
            blockSenders.forEach((id, blockSender) -> blockSender.send(player));
        }
        if (EMILoot.config.parseMobLoot) {
            mobSenders.forEach((id, mobSender) -> mobSender.send(player));
        }
        if (EMILoot.config.parseGameplayLoot) {
            gameplaySenders.forEach((id, gameplaySender) -> gameplaySender.send(player));
        }
        if (EMILoot.config.parseArchaeologyLoot) {
            archaeologySenders.forEach((id, archaeologySender) -> archaeologySender.send(player));
        }
    }

    public static void parseLootTables(LootDataManager manager, Map<LootDataId<?>, ?> tables) {
        keyLookUp.clear();
        LootTableParser.tables = tables;
        lootManager = manager;
        for (LootDataId<?> key2 : LootTableParser.tables.keySet()) {
            if (key2.f_278383_() != LootDataType.f_278413_) continue;
            keyLookUp.put(key2.f_278500_(), key2);
        }
        parsedDirectDrops = new LinkedList<ResourceLocation>();
        chestSenders.clear();
        blockSenders.clear();
        mobSenders.clear();
        gameplaySenders.clear();
        archaeologySenders.clear();
        try {
            EMILoot.LOGGER.info("parsing loot tables");
            tables.forEach((key, table) -> {
                if (table instanceof LootTable) {
                    LootTableParser.parseLootTable(key.f_278500_(), (LootTable)table);
                }
            });
            if (EMILoot.config.parseMobLoot) {
                ResourceLocation chk = new ResourceLocation("pig");
                BuiltInRegistries.f_256780_.m_123024_().toList().forEach(type -> {
                    if (type == EntityType.f_20520_) {
                        for (ResourceLocation sheepId : ServerResourceData.SHEEP_TABLES) {
                            LootTableParser.parseEntityType(manager, type, sheepId, chk);
                        }
                    }
                    LootTableParser.parseEntityType(manager, type, type.m_20677_(), chk);
                });
            }
            Multimap<ResourceLocation, LootTable> missedDrops = ServerResourceData.getMissedDirectDrops(parsedDirectDrops);
            for (Map.Entry entry : missedDrops.entries()) {
                if (EMILoot.DEBUG) {
                    EMILoot.LOGGER.info("parsing missed direct drop table: " + String.valueOf(entry.getKey()));
                }
                LootTableParser.parseLootTable((ResourceLocation)entry.getKey(), (LootTable)entry.getValue());
            }
            EMILoot.LOGGER.info("finished parsing loot tables");
            hasParsedLootTables = true;
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical unhandled error encountered while parsing loot tables. Results may be incomplete.");
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    private static void parseLootTable(ResourceLocation id, LootTable lootTable) {
        if (ServerResourceData.skipTable(id)) {
            return;
        }
        currentTable = id.toString();
        try {
            LootContextParamSet type = lootTable.m_79122_();
            if (type == LootContextParamSets.f_81411_ && EMILoot.config.parseChestLoot) {
                chestSenders.put(id, LootTableParser.parseChestLootTable(lootTable, id));
            } else if (type == LootContextParamSets.f_81421_ && EMILoot.config.parseBlockLoot) {
                blockSenders.put(id, LootTableParser.parseBlockLootTable(lootTable, id));
            } else if ((type == LootContextParamSets.f_81414_ || type == LootContextParamSets.f_81416_ || type == LootContextParamSets.f_81417_) && EMILoot.config.parseGameplayLoot) {
                gameplaySenders.put(id, LootTableParser.parseGameplayLootTable(lootTable, id));
            } else if (type == LootContextParamSets.f_271368_ && EMILoot.config.parseArchaeologyLoot) {
                archaeologySenders.put(id, LootTableParser.parseArchaeologyTable(lootTable, id));
            }
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical error encountered while parsing Loot Table {}", (Object)id);
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    public static void postProcess(PostProcessor process) {
        if (!hasParsedLootTables) {
            return;
        }
        try {
            for (LootSender lootSender : chestSenders.values()) {
                for (LootBuilder lootBuilder : lootSender.getBuilders()) {
                    for (LootPoolEntryContainer entry : lootBuilder.getEntriesToPostProcess(process)) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Post-processing builder in chest sender: {}", (Object)lootSender.getId());
                        }
                        LootTableParser.parseLootPoolEntry(lootBuilder, entry, process);
                    }
                }
                lootSender.build();
            }
            for (LootSender<ChestLootPoolBuilder> lootSender : blockSenders.values()) {
                for (LootBuilder lootBuilder : lootSender.getBuilders()) {
                    for (LootPoolEntryContainer entry : lootBuilder.getEntriesToPostProcess(process)) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Post-processing builder in block sender: {}", (Object)lootSender.getId());
                        }
                        LootTableParser.parseLootPoolEntry(lootBuilder, entry, process);
                    }
                }
                lootSender.build();
            }
            for (LootSender<ChestLootPoolBuilder> lootSender : mobSenders.values()) {
                for (LootBuilder lootBuilder : lootSender.getBuilders()) {
                    for (LootPoolEntryContainer entry : lootBuilder.getEntriesToPostProcess(process)) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Post-processing builder in mob sender: {}", (Object)lootSender.getId());
                        }
                        LootTableParser.parseLootPoolEntry(lootBuilder, entry, process);
                    }
                }
                lootSender.build();
            }
            for (LootSender<ChestLootPoolBuilder> lootSender : gameplaySenders.values()) {
                for (LootBuilder lootBuilder : lootSender.getBuilders()) {
                    for (LootPoolEntryContainer entry : lootBuilder.getEntriesToPostProcess(process)) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Post-processing builder in gameplay sender: {}", (Object)lootSender.getId());
                        }
                        LootTableParser.parseLootPoolEntry(lootBuilder, entry, process);
                    }
                }
                lootSender.build();
            }
            for (LootSender<ChestLootPoolBuilder> lootSender : archaeologySenders.values()) {
                for (LootBuilder lootBuilder : lootSender.getBuilders()) {
                    for (LootPoolEntryContainer entry : lootBuilder.getEntriesToPostProcess(process)) {
                        if (EMILoot.DEBUG) {
                            EMILoot.LOGGER.info("Post-processing builder in archaeology sender: {}", (Object)lootSender.getId());
                        }
                        LootTableParser.parseLootPoolEntry(lootBuilder, entry, process);
                    }
                }
                lootSender.build();
            }
            postProcessors.put((Object)process, true);
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical error encountered while post-processing for {}", (Object)process);
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    private static void parseEntityType(LootDataManager manager, EntityType<?> type, ResourceLocation mobTableId, ResourceLocation fallback) {
        try {
            ResourceLocation mobId = BuiltInRegistries.f_256780_.m_7981_(type);
            LootTable mobTable = manager.m_278676_(mobTableId);
            if (type == EntityType.f_20510_ && mobId.equals((Object)fallback) || mobTable != LootTable.f_79105_) {
                currentTable = mobTableId.toString();
                mobSenders.put(mobTableId, LootTableParser.parseMobLootTable(mobTable, mobTableId, mobId));
            } else if (EMILoot.DEBUG) {
                EMILoot.LOGGER.warn("Found empty mob table at id: " + String.valueOf(mobTableId));
            }
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical error encountered while parsing Mob Loot Table {}", (Object)mobTableId.toString());
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    private static ChestLootTableSender parseChestLootTable(LootTable lootTable, ResourceLocation id) {
        ChestLootTableSender sender = new ChestLootTableSender(id);
        for (LootPool pool : ((LootTablePools)lootTable).getPools()) {
            LootPoolEntryContainer[] entries;
            NumberProvider rollProvider = ((LootPoolAccessor)pool).getRolls();
            float conditionalMultiplier = 1.0f;
            for (LootItemCondition condition : ((LootPoolAccessor)pool).getConditions()) {
                if (!(condition instanceof LootItemRandomChanceCondition)) continue;
                conditionalMultiplier *= ((RandomChanceLootConditionAccessor)condition).getChance();
            }
            float rollAvg = NumberProcessors.getRollAvg(rollProvider) * conditionalMultiplier;
            ChestLootPoolBuilder builder = new ChestLootPoolBuilder(rollAvg);
            for (LootPoolEntryContainer entry : entries = ((LootPoolAccessor)pool).getEntries()) {
                LootTableParser.parseLootPoolEntry(builder, entry);
            }
            sender.addBuilder(builder);
        }
        return sender;
    }

    private static BlockLootTableSender parseBlockLootTable(LootTable lootTable, ResourceLocation id) {
        BlockLootTableSender sender = new BlockLootTableSender(id);
        LootTableParser.parseBlockLootTableInternal(lootTable, sender, false);
        if (ServerResourceData.DIRECT_DROPS.containsKey((Object)id) && EMILoot.config.mobLootIncludeDirectDrops) {
            parsedDirectDrops.add(id);
            Collection directTables = ServerResourceData.DIRECT_DROPS.get((Object)id);
            LootTableParser.parseBlockDirectLootTable(directTables, sender);
        }
        return sender;
    }

    private static void parseBlockDirectLootTable(Collection<LootTable> tables, BlockLootTableSender sender) {
        for (LootTable directTable : tables) {
            if (directTable == null) continue;
            LootTableParser.parseBlockLootTableInternal(directTable, sender, true);
        }
    }

    private static void parseBlockLootTableInternal(LootTable lootTable, BlockLootTableSender sender, boolean isDirect) {
        for (LootPool pool : ((LootTablePools)lootTable).getPools()) {
            LootPoolEntryContainer[] entries;
            LootItemCondition[] conditions = ((LootPoolAccessor)pool).getConditions();
            List<LootConditionResult> parsedConditions = LootTableParser.parseLootConditions(conditions, ItemStack.f_41583_, false);
            if (isDirect) {
                if (EMILoot.DEBUG) {
                    EMILoot.LOGGER.info("Adding direct drop block condition to {}", (Object)currentTable);
                }
                parsedConditions.add(new LootConditionResult(TextKey.of("emi_loot.condition.direct_drop")));
            }
            LootItemFunction[] functions = ((LootPoolAccessor)pool).getFunctions();
            LinkedList<LootFunctionResult> parsedFunctions = new LinkedList<LootFunctionResult>();
            for (LootItemFunction function : functions) {
                LootFunctionResult r = LootTableParser.parseLootFunction(function);
                if (r.skip()) continue;
                parsedFunctions.add(r);
            }
            NumberProvider rollProvider = ((LootPoolAccessor)pool).getRolls();
            float rollAvg = NumberProcessors.getRollAvg(rollProvider);
            BlockLootPoolBuilder builder = new BlockLootPoolBuilder(rollAvg, parsedConditions, parsedFunctions);
            for (LootPoolEntryContainer entry : entries = ((LootPoolAccessor)pool).getEntries()) {
                LootTableParser.parseLootPoolEntry(builder, entry);
            }
            sender.addBuilder(builder);
        }
    }

    private static MobLootTableSender parseMobLootTable(LootTable lootTable, ResourceLocation id, ResourceLocation mobId) {
        MobLootTableSender sender = new MobLootTableSender(id, mobId);
        LootTableParser.parseMobLootTableInternal(lootTable, sender, false);
        if (ServerResourceData.DIRECT_DROPS.containsKey((Object)id) && EMILoot.config.mobLootIncludeDirectDrops) {
            parsedDirectDrops.add(id);
            Collection directTables = ServerResourceData.DIRECT_DROPS.get((Object)id);
            LootTableParser.parseMobDirectLootTable(directTables, sender);
        }
        return sender;
    }

    private static void parseMobDirectLootTable(Collection<LootTable> tables, MobLootTableSender sender) {
        for (LootTable directTable : tables) {
            if (directTable == null) continue;
            LootTableParser.parseMobLootTableInternal(directTable, sender, true);
        }
    }

    private static void parseMobLootTableInternal(LootTable lootTable, MobLootTableSender sender, boolean isDirect) {
        for (LootPool pool : ((LootTablePools)lootTable).getPools()) {
            LootPoolEntryContainer[] entries;
            LootItemCondition[] conditions = ((LootPoolAccessor)pool).getConditions();
            List<LootConditionResult> parsedConditions = LootTableParser.parseLootConditions(conditions, ItemStack.f_41583_, false);
            if (isDirect) {
                if (EMILoot.DEBUG) {
                    EMILoot.LOGGER.info("Adding direct drop mob condition to {}", (Object)currentTable);
                }
                parsedConditions.add(new LootConditionResult(TextKey.of("emi_loot.condition.direct_drop")));
            }
            LootItemFunction[] functions = ((LootPoolAccessor)pool).getFunctions();
            LinkedList<LootFunctionResult> parsedFunctions = new LinkedList<LootFunctionResult>();
            for (LootItemFunction function : functions) {
                LootFunctionResult r = LootTableParser.parseLootFunction(function);
                if (r.skip()) continue;
                parsedFunctions.add(r);
            }
            NumberProvider rollProvider = ((LootPoolAccessor)pool).getRolls();
            float rollAvg = NumberProcessors.getRollAvg(rollProvider);
            MobLootPoolBuilder builder = new MobLootPoolBuilder(rollAvg, parsedConditions, parsedFunctions);
            for (LootPoolEntryContainer entry : entries = ((LootPoolAccessor)pool).getEntries()) {
                LootTableParser.parseLootPoolEntry(builder, entry);
            }
            sender.addBuilder(builder);
        }
    }

    private static GameplayLootTableSender parseGameplayLootTable(LootTable lootTable, ResourceLocation id) {
        GameplayLootTableSender sender = new GameplayLootTableSender(id);
        for (LootPool pool : ((LootTablePools)lootTable).getPools()) {
            LootPoolEntryContainer[] entries;
            LootItemCondition[] conditions = ((LootPoolAccessor)pool).getConditions();
            List<LootConditionResult> parsedConditions = LootTableParser.parseLootConditions(conditions, ItemStack.f_41583_, false);
            LootItemFunction[] functions = ((LootPoolAccessor)pool).getFunctions();
            LinkedList<LootFunctionResult> parsedFunctions = new LinkedList<LootFunctionResult>();
            for (LootItemFunction function : functions) {
                LootFunctionResult r = LootTableParser.parseLootFunction(function);
                if (r.skip()) continue;
                parsedFunctions.add(r);
            }
            NumberProvider rollProvider = ((LootPoolAccessor)pool).getRolls();
            float rollAvg = NumberProcessors.getRollAvg(rollProvider);
            GameplayLootPoolBuilder builder = new GameplayLootPoolBuilder(rollAvg, parsedConditions, parsedFunctions);
            for (LootPoolEntryContainer entry : entries = ((LootPoolAccessor)pool).getEntries()) {
                LootTableParser.parseLootPoolEntry(builder, entry);
            }
            sender.addBuilder(builder);
        }
        return sender;
    }

    private static ArchaeologyLootTableSender parseArchaeologyTable(LootTable lootTable, ResourceLocation id) {
        ArchaeologyLootTableSender sender = new ArchaeologyLootTableSender(id);
        for (LootPool pool : ((LootTablePools)lootTable).getPools()) {
            LootPoolEntryContainer[] entries;
            NumberProvider rollProvider = ((LootPoolAccessor)pool).getRolls();
            float rollAvg = NumberProcessors.getRollAvg(rollProvider);
            ArchaeologyLootPoolBuilder builder = new ArchaeologyLootPoolBuilder(rollAvg);
            for (LootPoolEntryContainer entry : entries = ((LootPoolAccessor)pool).getEntries()) {
                LootTableParser.parseLootPoolEntry(builder, entry);
            }
            sender.addBuilder(builder);
        }
        return sender;
    }

    static void parseLootPoolEntry(LootBuilder builder, LootPoolEntryContainer entry) {
        LootTableParser.parseLootPoolEntry(builder, entry, null);
    }

    static void parseLootPoolEntry(LootBuilder builder, LootPoolEntryContainer entry, @Nullable PostProcessor process) {
        if (entry instanceof TagEntry) {
            TagEntry tagEntry = (TagEntry)entry;
            if (process == PostProcessor.TAG) {
                List<ItemEntryResult> result = LootTableParser.parseTagEntry(tagEntry, false);
                result.forEach(builder::addItem);
            } else {
                builder.addEntryForPostProcessing(PostProcessor.TAG, (LootPoolEntryContainer)tagEntry);
            }
        } else {
            List<ItemEntryResult> result = LootTableParser.parseLootPoolEntry(entry, false);
            result.forEach(builder::addItem);
        }
    }

    static List<ItemEntryResult> parseLootPoolEntry(LootPoolEntryContainer entry, boolean parentIsAlternative) {
        if (entry instanceof LootItem) {
            LootItem itemEntry = (LootItem)entry;
            return LootTableParser.parseItemEntry(itemEntry, parentIsAlternative);
        }
        if (entry instanceof AlternativesEntry) {
            AlternativesEntry alternativeEntry = (AlternativesEntry)entry;
            return LootTableParser.parseAlternativeEntry(alternativeEntry);
        }
        if (entry instanceof EntryGroup) {
            EntryGroup groupEntry = (EntryGroup)entry;
            return LootTableParser.parseGroupEntry(groupEntry, parentIsAlternative);
        }
        if (entry instanceof SequentialEntry) {
            SequentialEntry sequenceEntry = (SequentialEntry)entry;
            return LootTableParser.parseSequenceEntry(sequenceEntry, parentIsAlternative);
        }
        if (entry instanceof TagEntry) {
            TagEntry tagEntry = (TagEntry)entry;
            return LootTableParser.parseTagEntry(tagEntry, parentIsAlternative);
        }
        if (entry instanceof LootTableReference) {
            LootTableReference lootTableEntry = (LootTableReference)entry;
            return LootTableParser.parseLootTableEntry(lootTableEntry, parentIsAlternative);
        }
        return List.of();
    }

    static List<ItemEntryResult> parseItemEntry(LootItem entry, boolean parentIsAlternative) {
        int weight = ((LeafEntryAccessor)entry).getWeight();
        ItemStack item = new ItemStack((ItemLike)((ItemEntryAccessor)entry).getItem());
        LootItemFunction[] functions = ((LeafEntryAccessor)entry).getFunctions();
        LootItemCondition[] conditions = ((LootPoolEntryAccessor)entry).getConditions();
        return LootTableParser.parseItemEntry(weight, item, functions, conditions, parentIsAlternative);
    }

    static List<ItemEntryResult> parseItemEntry(int weight, ItemStack item, LootItemFunction[] functions, LootItemCondition[] conditions, boolean parentIsAlternative) {
        FunctionApplierResult functionApplierResult = LootTableParser.applyLootFunctionToItem(functions, item, weight, parentIsAlternative);
        List<ItemEntryResult> conditionalEntryResults = functionApplierResult.conditionalResults;
        List<TextKey> functionTexts = functionApplierResult.functionTexts;
        item = functionApplierResult.stack;
        List<TextKey> conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, item, parentIsAlternative);
        LinkedList<ItemEntryResult> returnList = new LinkedList<ItemEntryResult>();
        returnList.add(new ItemEntryResult(item, weight, conditionsTexts, functionTexts));
        conditionalEntryResults.forEach(conditionalEntry -> {
            conditionalEntry.conditions.addAll(conditionsTexts);
            conditionalEntry.functions.addAll(functionTexts);
            returnList.add((ItemEntryResult)conditionalEntry);
        });
        return returnList;
    }

    static List<ItemEntryResult> parseTagEntry(TagEntry entry, boolean parentIsAlternative) {
        TagKey<Item> items = ((TagEntryAccessor)entry).getName();
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.info(">>> Parsing tag entry {}", (Object)items.f_203868_());
        }
        Iterable itemsItr = BuiltInRegistries.f_257033_.m_206058_(items);
        LinkedList<ItemEntryResult> returnList = new LinkedList<ItemEntryResult>();
        int weight = ((LeafEntryAccessor)entry).getWeight();
        LootItemFunction[] functions = ((LeafEntryAccessor)entry).getFunctions();
        LootItemCondition[] conditions = ((LootPoolEntryAccessor)entry).getConditions();
        for (Holder item : itemsItr) {
            ItemStack stack = new ItemStack((ItemLike)item.m_203334_());
            returnList.addAll(LootTableParser.parseItemEntry(weight, stack, functions, conditions, parentIsAlternative));
        }
        return returnList;
    }

    static List<ItemEntryResult> parseAlternativeEntry(AlternativesEntry entry) {
        LootPoolEntryContainer[] children = ((CombinedEntryAccessor)entry).getChildren();
        LootItemCondition[] conditions = ((LootPoolEntryAccessor)entry).getConditions();
        List<TextKey> conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, ItemStack.f_41583_, true);
        LinkedList<ItemEntryResult> results = new LinkedList<ItemEntryResult>();
        Arrays.stream(children).forEach(lootEntry -> {
            List<ItemEntryResult> result = LootTableParser.parseLootPoolEntry(lootEntry, true);
            result.forEach(resultEntry -> {
                resultEntry.conditions.addAll(conditionsTexts);
                results.add((ItemEntryResult)resultEntry);
            });
        });
        return results;
    }

    static List<ItemEntryResult> parseGroupEntry(EntryGroup entry, boolean parentIsAlternative) {
        LootPoolEntryContainer[] children = ((CombinedEntryAccessor)entry).getChildren();
        LootItemCondition[] conditions = ((LootPoolEntryAccessor)entry).getConditions();
        List<TextKey> conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, ItemStack.f_41583_, parentIsAlternative);
        LinkedList<ItemEntryResult> results = new LinkedList<ItemEntryResult>();
        Arrays.stream(children).forEach(lootEntry -> {
            List<ItemEntryResult> result = LootTableParser.parseLootPoolEntry(lootEntry, parentIsAlternative);
            result.forEach(resultEntry -> {
                resultEntry.conditions.addAll(conditionsTexts);
                results.add((ItemEntryResult)resultEntry);
            });
        });
        return results;
    }

    static List<ItemEntryResult> parseSequenceEntry(SequentialEntry entry, boolean parentIsAlternative) {
        LootPoolEntryContainer[] children = ((CombinedEntryAccessor)entry).getChildren();
        LootItemCondition[] conditions = ((LootPoolEntryAccessor)entry).getConditions();
        List<TextKey> conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, ItemStack.f_41583_, parentIsAlternative);
        LinkedList<ItemEntryResult> results = new LinkedList<ItemEntryResult>();
        TextKey sequenceCondition = TextKey.of("emi_loot.condition.sequence");
        Arrays.stream(children).forEach(lootEntry -> {
            List<ItemEntryResult> result = LootTableParser.parseLootPoolEntry(lootEntry, parentIsAlternative);
            result.forEach(resultEntry -> {
                resultEntry.conditions.addAll(conditionsTexts);
                resultEntry.conditions.add(sequenceCondition);
                results.add((ItemEntryResult)resultEntry);
            });
        });
        return results;
    }

    static List<ItemEntryResult> parseLootTableEntry(LootTableReference entry, boolean parentIsAlternative) {
        ResourceLocation id = ((LootTableEntryAccessor)entry).getId();
        if (keyLookUp.containsKey(id) && tables.containsKey(keyLookUp.get(id))) {
            Object temp = tables.get(keyLookUp.get(id));
            if (!(temp instanceof LootTable)) {
                return List.of();
            }
            LootTable table = (LootTable)temp;
            LootContextParamSet type = table.m_79122_();
            LootItemCondition[] conditions = ((LootPoolEntryAccessor)entry).getConditions();
            List<TextKey> conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, ItemStack.f_41583_, parentIsAlternative);
            LootSender<ChestLootPoolBuilder> results = type == LootContextParamSets.f_81411_ ? LootTableParser.parseChestLootTable(table, id) : (type == LootContextParamSets.f_81421_ ? LootTableParser.parseBlockLootTable(table, id) : (type == LootContextParamSets.f_81415_ ? LootTableParser.parseMobLootTable(table, id, new ResourceLocation("empty")) : (type == LootContextParamSets.f_81414_ ? LootTableParser.parseGameplayLootTable(table, id) : (type == LootContextParamSets.f_271368_ ? LootTableParser.parseArchaeologyTable(table, id) : new EmptyLootTableSender()))));
            List<LootBuilder> parsedBuilders = results.getBuilders();
            LinkedList<ItemEntryResult> parsedList = new LinkedList<ItemEntryResult>();
            parsedBuilders.forEach(parsedBuilder -> parsedList.addAll(parsedBuilder.revert()));
            parsedList.forEach(result -> result.conditions.addAll(conditionsTexts));
            LootItemFunction[] functions = ((LeafEntryAccessor)entry).getFunctions();
            return LootTableParser.applyLootFunctionsToTableResults(functions, parsedList, parentIsAlternative);
        }
        return List.of();
    }

    static LootFunctionResult parseLootFunction(LootItemFunction function) {
        return LootTableParser.parseLootFunction(function, ItemStack.f_41583_, false);
    }

    static LootFunctionResult parseLootFunction(LootItemFunction function, ItemStack stack, boolean parentIsAlternative) {
        LinkedList<TextKey> conditionsTexts;
        LootItemFunctionType type;
        try {
            type = function.m_7162_();
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to determine a function type for stack {} in table {}", (Object)stack.m_41786_(), (Object)currentTable);
            EMILoot.LOGGER.error("Thrown Error:", (Throwable)e);
            return LootFunctionResult.EMPTY;
        }
        if (function instanceof LootItemConditionalFunction) {
            LootItemCondition[] conditions = ((ConditionalLootFunctionAccessor)function).getConditions();
            conditionsTexts = LootTableParser.parseLootConditionTexts(conditions, stack, parentIsAlternative);
        } else {
            conditionsTexts = new LinkedList();
        }
        try {
            return LootParserRegistry.parseFunction(function, stack, type, parentIsAlternative, conditionsTexts);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to parse LootFunction of type {} for stack {} in table {}", new Object[]{type, stack.m_41786_(), currentTable});
            EMILoot.LOGGER.error("Thrown Error:", (Throwable)e);
            return LootFunctionResult.EMPTY;
        }
    }

    private static List<ItemEntryResult> applyLootFunctionsToTableResults(LootItemFunction[] functions, List<ItemEntryResult> parsedList, boolean parentIsAlternative) {
        LinkedList conditionalEntryResults = new LinkedList();
        LinkedList<ItemEntryResult> processedEntryResults = new LinkedList<ItemEntryResult>();
        parsedList.forEach(itemEntry -> {
            FunctionApplierResult result = LootTableParser.applyLootFunctionToItem(functions, itemEntry.item, itemEntry.weight, parentIsAlternative);
            List<TextKey> conditionTexts = itemEntry.conditions;
            List<TextKey> functionTexts = itemEntry.functions;
            functionTexts.addAll(result.functionTexts);
            processedEntryResults.add(new ItemEntryResult(result.stack, itemEntry.weight, conditionTexts, functionTexts));
            conditionalEntryResults.addAll(result.conditionalResults);
        });
        processedEntryResults.addAll(conditionalEntryResults);
        return processedEntryResults;
    }

    private static FunctionApplierResult applyLootFunctionToItem(LootItemFunction[] functions, ItemStack item, int weight, boolean parentIsAlternative) {
        LinkedList<TextKey> functionTexts = new LinkedList<TextKey>();
        LinkedList<ItemEntryResult> conditionalEntryResults = new LinkedList<ItemEntryResult>();
        for (LootItemFunction lootFunction : functions) {
            LootFunctionResult result = LootTableParser.parseLootFunction(lootFunction, item, parentIsAlternative);
            TextKey lootText = result.text;
            ItemStack newStack = result.stack;
            List<TextKey> resultConditions = result.conditions;
            if (!resultConditions.isEmpty()) {
                ItemStack conditionalItem = newStack != ItemStack.f_41583_ ? newStack : item;
                ArrayList<TextKey> conditionalFunctionTexts = new ArrayList<TextKey>();
                conditionalFunctionTexts.add(lootText);
                conditionalEntryResults.add(new ItemEntryResult(conditionalItem, weight, resultConditions, conditionalFunctionTexts));
                continue;
            }
            if (lootText.isNotEmpty() && !lootText.skip()) {
                functionTexts.add(lootText);
            }
            if (newStack == ItemStack.f_41583_) continue;
            item = newStack;
        }
        return new FunctionApplierResult(conditionalEntryResults, functionTexts, item);
    }

    public static List<TextKey> parseLootConditionTexts(LootItemCondition[] conditions, ItemStack item, boolean parentIsAlternative) {
        LinkedList<TextKey> conditionsTexts = new LinkedList<TextKey>();
        List<LootConditionResult> parsedConditions = LootTableParser.parseLootConditions(conditions, item, parentIsAlternative);
        for (LootConditionResult result : parsedConditions) {
            conditionsTexts.add(result.text);
        }
        return conditionsTexts;
    }

    public static List<LootConditionResult> parseLootConditions(LootItemCondition[] conditions, ItemStack item, boolean parentIsAlternative) {
        LinkedList<LootConditionResult> parsedConditions = new LinkedList<LootConditionResult>();
        for (LootItemCondition condition : conditions) {
            List<LootConditionResult> results = LootTableParser.parseLootCondition(condition, item, parentIsAlternative);
            for (LootConditionResult result : results) {
                if (!result.text.isNotEmpty()) continue;
                parsedConditions.add(result);
            }
        }
        return parsedConditions;
    }

    public static List<LootConditionResult> parseLootCondition(LootItemCondition condition, ItemStack stack) {
        return LootTableParser.parseLootCondition(condition, stack, false);
    }

    public static List<LootConditionResult> parseLootCondition(LootItemCondition condition, ItemStack stack, boolean parentIsAlternative) {
        LootItemConditionType type;
        try {
            type = condition.m_7940_();
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("failed to determine a condition type for stack {} in table {}", (Object)stack.m_41786_(), (Object)currentTable);
            return Collections.singletonList(LootConditionResult.EMPTY);
        }
        try {
            return LootParserRegistry.parseCondition(condition, type, stack, parentIsAlternative);
        }
        catch (Exception e) {
            EMILoot.LOGGER.error("Failed to parse LootCondition of type {} for stack {} in table {}", new Object[]{condition.m_7940_(), stack.m_41786_(), currentTable});
            EMILoot.LOGGER.error("Thrown Error:", (Throwable)e);
            return Collections.singletonList(LootConditionResult.EMPTY);
        }
    }

    public static Component compileConditionTexts(ItemStack stack, List<LootConditionResult> results) {
        MutableComponent finalText = LText.empty();
        int size = results.size();
        for (int i = 0; i < size; ++i) {
            LootConditionResult result = results.get(i);
            Component resultText = result.text.process(stack, null).text();
            if (i == 0) {
                finalText = resultText.m_6881_();
            } else {
                finalText.m_7220_(resultText);
            }
            if (i >= size - 1) continue;
            finalText.m_7220_((Component)LText.translatable("emi_loot.and"));
        }
        return finalText;
    }

    static {
        tables = new HashMap();
        keyLookUp = new HashMap();
        currentTable = "none";
        parsedDirectDrops = new LinkedList<ResourceLocation>();
        hasParsedLootTables = false;
        lootManager = null;
        CLEAR_LOOTS = new ResourceLocation("e_l", "clear");
        Object2BooleanOpenHashMap map = new Object2BooleanOpenHashMap();
        for (PostProcessor value : PostProcessor.values()) {
            map.put((Object)value, false);
        }
        postProcessors = map;
    }

    public static enum PostProcessor {
        TAG;

    }

    public record LootConditionResult(TextKey text) {
        public static LootConditionResult EMPTY = new LootConditionResult(TextKey.empty());

        public TextKey getText() {
            return this.text;
        }
    }

    public record LootFunctionResult(TextKey text, ItemStack stack, List<TextKey> conditions) {
        public static LootFunctionResult EMPTY = new LootFunctionResult(TextKey.empty(), ItemStack.f_41583_, new LinkedList<TextKey>());

        public boolean skip() {
            return this.conditions.isEmpty() && this.text.skip();
        }
    }

    public record FunctionApplierResult(List<ItemEntryResult> conditionalResults, List<TextKey> functionTexts, ItemStack stack) {
    }

    public record ItemEntryResult(ItemStack item, int weight, List<TextKey> conditions, List<TextKey> functions) {
    }
}

