/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import com.google.gson.JsonObject;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.FishingHookPredicateAccessor;
import fzzyhmstrs.emi_loot.mixins.LightningBoltPredicateAccessor;
import fzzyhmstrs.emi_loot.mixins.PlayerPredicateAccessor;
import fzzyhmstrs.emi_loot.mixins.SlimePredicateAccessor;
import fzzyhmstrs.emi_loot.parser.EntityPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.processor.ListProcessors;
import fzzyhmstrs.emi_loot.parser.processor.NumberProcessors;
import fzzyhmstrs.emi_loot.util.LText;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.LighthingBoltPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.GameType;

public class TypeSpecificPredicateParser {
    public static Component parseTypeSpecificPredicate(EntitySubPredicate predicate) {
        String variant;
        ResourceLocation id;
        if (predicate instanceof LighthingBoltPredicate) {
            return TypeSpecificPredicateParser.parseLightningBoltPredicate((LighthingBoltPredicate)predicate);
        }
        if (predicate instanceof FishingHookPredicate) {
            return TypeSpecificPredicateParser.parseFishingHookPredicate((FishingHookPredicate)predicate);
        }
        if (predicate instanceof PlayerPredicate) {
            return TypeSpecificPredicateParser.parsePlayerPredicate((PlayerPredicate)predicate);
        }
        if (predicate instanceof SlimePredicate) {
            return TypeSpecificPredicateParser.parseSlimePredicate((SlimePredicate)predicate);
        }
        JsonObject jsonObject = predicate.m_213616_();
        if (jsonObject.has("variant") && (id = ResourceLocation.m_135820_((String)(variant = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"variant")))) != null) {
            if (BuiltInRegistries.f_256754_.m_7804_(id)) {
                MutableComponent catVar = LText.translatable("emi_loot.entity_predicate.type_specific.cat." + String.valueOf(id));
                return LText.translatable("emi_loot.entity_predicate.type_specific.cat", catVar.getString());
            }
            if (BuiltInRegistries.f_256770_.m_7804_(id)) {
                MutableComponent frogVar = LText.translatable("emi_loot.entity_predicate.type_specific.frog." + String.valueOf(id));
                return LText.translatable("emi_loot.entity_predicate.type_specific.frog", frogVar.getString());
            }
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Type specific predicate undefined or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static Component parseLightningBoltPredicate(LighthingBoltPredicate predicate) {
        MinMaxBounds.Ints blocksSetOnFire = ((LightningBoltPredicateAccessor)predicate).getBlocksSetOnFire();
        if (!blocksSetOnFire.equals(MinMaxBounds.Ints.f_55364_)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.lightning", NumberProcessors.processNumberRange(blocksSetOnFire, "emi_loot.entity_predicate.type_specific.lightning.blocks", "emi_loot.entity_predicate.type_specific.lightning.blocks_2", "emi_loot.entity_predicate.type_specific.lightning.blocks_3", "emi_loot.entity_predicate.type_specific.lightning.blocks_4", "", new Object[0]));
        }
        EntityPredicate entityStruck = ((LightningBoltPredicateAccessor)predicate).getEntityStruck();
        if (!entityStruck.equals(EntityPredicate.f_36550_)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.lightning", LText.translatable("emi_loot.entity_predicate.type_specific.lightning.struck", EntityPredicateParser.parseEntityPredicate(entityStruck).getString()));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Lightning bolt predicate empty or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static Component parseFishingHookPredicate(FishingHookPredicate predicate) {
        boolean inOpenWater = ((FishingHookPredicateAccessor)predicate).getInOpenWater();
        return inOpenWater ? LText.translatable("emi_loot.entity_predicate.type_specific.fishing_hook_true") : LText.translatable("emi_loot.entity_predicate.type_specific.fishing_hook_false");
    }

    public static Component parsePlayerPredicate(PlayerPredicate predicate) {
        Map<ResourceLocation, PlayerPredicate.AdvancementPredicate> advancements;
        Object2BooleanMap<ResourceLocation> recipes;
        MinMaxBounds.Ints experienceLevel = ((PlayerPredicateAccessor)predicate).getExperienceLevel();
        if (!experienceLevel.equals(MinMaxBounds.Ints.f_55364_)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", NumberProcessors.processNumberRange(experienceLevel, "emi_loot.entity_predicate.type_specific.player.level", "emi_loot.entity_predicate.type_specific.player.level_2", "emi_loot.entity_predicate.type_specific.player.level_3", "emi_loot.entity_predicate.type_specific.player.level_4", "", new Object[0]));
        }
        GameType gameMode = ((PlayerPredicateAccessor)predicate).getGameMode();
        if (gameMode != null) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", LText.translatable("emi_loot.entity_predicate.type_specific.player.gamemode", gameMode.m_46405_()));
        }
        Map<Stat<?>, MinMaxBounds.Ints> stats = ((PlayerPredicateAccessor)predicate).getStats();
        if (!stats.isEmpty()) {
            LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
            for (Map.Entry<Stat<?>, MinMaxBounds.Ints> entry : stats.entrySet()) {
                String name = entry.getKey().m_83620_();
                String[] namePieces = name.split(":");
                if (namePieces.length != 2) continue;
                String typeId = namePieces[0].replace('.', ':');
                String valueId = namePieces[1].replace('.', ':');
                MutableComponent num = NumberProcessors.processNumberRange((MinMaxBounds)entry.getValue(), "emi_loot.entity_predicate.type_specific.player.stats.exact", "emi_loot.entity_predicate.type_specific.player.stats.between", "emi_loot.entity_predicate.type_specific.player.stats.at_least", "emi_loot.entity_predicate.type_specific.player.stats.at_most", "emi_loot.entity_predicate.type_specific.player.stats.fallback", new Object[0]);
                list.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.stats.type." + typeId, valueId, num));
            }
            if (!list.isEmpty()) {
                return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(list));
            }
        }
        if (!(recipes = ((PlayerPredicateAccessor)predicate).getRecipes()).isEmpty()) {
            LinkedList<MutableComponent> list = new LinkedList<MutableComponent>();
            for (Object2BooleanMap.Entry entry : recipes.object2BooleanEntrySet()) {
                list.add(entry.getBooleanValue() ? LText.translatable("emi_loot.entity_predicate.type_specific.player.recipe_true", entry.getKey()) : LText.translatable("emi_loot.entity_predicate.type_specific.player.recipe_false", entry.getKey()));
            }
            if (!list.isEmpty()) {
                return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(list));
            }
        }
        if (!(advancements = ((PlayerPredicateAccessor)predicate).getAdvancements()).isEmpty()) {
            LinkedList<MutableComponent> linkedList = new LinkedList<MutableComponent>();
            for (Map.Entry<ResourceLocation, PlayerPredicate.AdvancementPredicate> entry : advancements.entrySet()) {
                Object2BooleanMap criteria;
                String idString = entry.getKey().toString();
                PlayerPredicate.AdvancementPredicate advancementPredicate = entry.getValue();
                if (advancementPredicate instanceof PlayerPredicate.AdvancementDonePredicate) {
                    boolean done = ((PlayerPredicate.AdvancementDonePredicate)advancementPredicate).f_62299_;
                    if (done) {
                        linkedList.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.id_true", idString));
                        continue;
                    }
                    linkedList.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.id_false", idString));
                    continue;
                }
                if (!(advancementPredicate instanceof PlayerPredicate.AdvancementCriterionsPredicate) || (criteria = ((PlayerPredicate.AdvancementCriterionsPredicate)advancementPredicate).f_62291_).isEmpty()) continue;
                LinkedList<MutableComponent> list2 = new LinkedList<MutableComponent>();
                for (Object2BooleanMap.Entry criteriaEntry : criteria.object2BooleanEntrySet()) {
                    if (criteriaEntry.getBooleanValue()) {
                        list2.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_true", criteriaEntry.getKey()));
                        continue;
                    }
                    list2.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_false", criteriaEntry.getKey()));
                }
                linkedList.add(LText.translatable("emi_loot.entity_predicate.type_specific.player.adv.crit_base", idString, ListProcessors.buildAndList(list2)));
            }
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", ListProcessors.buildAndList(linkedList));
        }
        EntityPredicate entityPredicate = ((PlayerPredicateAccessor)predicate).getLookingAt();
        if (!entityPredicate.equals(EntityPredicate.f_36550_)) {
            return LText.translatable("emi_loot.entity_predicate.type_specific.player", LText.translatable("emi_loot.entity_predicate.type_specific.player.looking", EntityPredicateParser.parseEntityPredicate(entityPredicate)));
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Lightning bolt predicate empty or unparsable. Affects table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }

    public static Component parseSlimePredicate(SlimePredicate predicate) {
        MinMaxBounds.Ints size = ((SlimePredicateAccessor)predicate).getSize();
        if (size.equals(MinMaxBounds.Ints.f_55364_)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.warn("Undefined slime size predicate in table: " + LootTableParser.currentTable);
            }
            return LText.translatable("emi_loot.predicate.invalid");
        }
        return NumberProcessors.processNumberRange(size, "emi_loot.entity_predicate.type_specific.slime", "emi_loot.entity_predicate.type_specific.slime_2", "emi_loot.entity_predicate.type_specific.slime_3", "emi_loot.entity_predicate.type_specific.slime_4", "", new Object[0]);
    }
}

