/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.server.ChestLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import fzzyhmstrs.emi_loot.server.MobLootPoolBuilder;
import fzzyhmstrs.emi_loot.util.SimpleFzzyPayload;
import fzzyhmstrs.emi_loot.util.TextKey;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.networking.FzzyPayload;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MobLootTableSender
implements LootSender<MobLootPoolBuilder> {
    private final String idToSend;
    private final String mobIdToSend;
    final List<MobLootPoolBuilder> builderList = new LinkedList<MobLootPoolBuilder>();
    public static ResourceLocation MOB_SENDER = new ResourceLocation("e_l", "m_s");
    boolean isEmpty = true;

    public MobLootTableSender(ResourceLocation id, ResourceLocation mobId) {
        this.idToSend = LootSender.getIdToSend(id);
        this.mobIdToSend = LootSender.getIdToSend(mobId);
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            if (!builder.isEmpty) {
                this.isEmpty = false;
            }
        });
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void send(ServerPlayer player) {
        if (!ConfigApi.INSTANCE.network().canSend(MOB_SENDER, (Player)player)) {
            return;
        }
        if (this.isEmpty) {
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info("avoiding empty mob: " + this.idToSend);
            }
            return;
        }
        FriendlyByteBuf buf = ConfigApi.INSTANCE.network().buf();
        buf.m_130070_(this.idToSend);
        buf.m_130070_(this.mobIdToSend);
        if (this.builderList.size() == 1 && this.builderList.get((int)0).isSimple) {
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info("sending simple mob: " + this.idToSend);
            }
            buf.writeShort(-1);
            buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)this.builderList.get((int)0).simpleStack.m_41720_());
            ConfigApi.INSTANCE.network().send((FzzyPayload)new SimpleFzzyPayload(buf, MOB_SENDER), (Player)player);
            return;
        }
        if (this.builderList.isEmpty()) {
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info("avoiding empty mob: " + this.idToSend);
            }
            return;
        }
        buf.writeShort(this.builderList.size());
        this.builderList.forEach(builder -> {
            ArrayList totalConditions = new ArrayList();
            builder.conditions.forEach(lootConditionResult -> totalConditions.add(lootConditionResult.text()));
            builder.functions.forEach(lootFunctionResult -> totalConditions.addAll(lootFunctionResult.conditions()));
            buf.writeShort(totalConditions.size());
            totalConditions.forEach(lootConditionResult -> lootConditionResult.toBuf(buf));
            buf.writeShort(builder.functions.size());
            builder.functions.forEach(lootFunctionResult -> lootFunctionResult.text().toBuf(buf));
            HashMap<List<TextKey>, ChestLootPoolBuilder> lootPoolBuilderMap = builder.builtMap;
            buf.writeShort(lootPoolBuilderMap.size());
            lootPoolBuilderMap.forEach((key, chestBuilder) -> {
                buf.writeShort(key.size());
                key.forEach(textKey -> textKey.toBuf(buf));
                Object2FloatMap<ItemStack> keyPoolMap = lootPoolBuilderMap.getOrDefault((Object)key, new ChestLootPoolBuilder((float)1.0f)).builtMap;
                buf.writeShort(keyPoolMap.size());
                keyPoolMap.forEach((stack, weight) -> {
                    this.writeItemStack(buf, (ItemStack)stack, player.m_9236_());
                    buf.writeFloat(weight.floatValue());
                });
            });
        });
        ConfigApi.INSTANCE.network().send((FzzyPayload)new SimpleFzzyPayload(buf, MOB_SENDER), (Player)player);
    }

    @Override
    public void addBuilder(MobLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<MobLootPoolBuilder> getBuilders() {
        return this.builderList;
    }
}

