/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util;

import dev.emi.emi.api.render.EmiRender;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.compress.utils.Lists;

public class QuantityListEmiIngredient
implements EmiIngredient {
    private final List<EmiStack> ingredients;

    public QuantityListEmiIngredient(List<EmiStack> ingredients) {
        this.ingredients = ingredients;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QuantityListEmiIngredient) {
            QuantityListEmiIngredient other = (QuantityListEmiIngredient)obj;
            return other.getEmiStacks().equals(this.getEmiStacks());
        }
        return false;
    }

    public int hashCode() {
        return this.ingredients.hashCode();
    }

    public EmiIngredient copy() {
        return new QuantityListEmiIngredient(this.ingredients);
    }

    public String toString() {
        return "Ingredient" + String.valueOf(this.getEmiStacks());
    }

    public List<EmiStack> getEmiStacks() {
        return this.ingredients;
    }

    public long getAmount() {
        return 1L;
    }

    public EmiIngredient setAmount(long amount) {
        return this;
    }

    public float getChance() {
        return 1.0f;
    }

    public EmiIngredient setChance(float chance) {
        return this;
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        int item = (int)(System.currentTimeMillis() / 1000L % (long)this.ingredients.size());
        EmiIngredient current = (EmiIngredient)this.ingredients.get(item);
        if ((flags & 1) != 0) {
            current.render(draw, x, y, delta, -3);
        }
        if ((flags & 2) != 0) {
            current.render(draw, x, y, delta, 2);
        }
        if ((flags & 4) != 0) {
            EmiRender.renderIngredientIcon((EmiIngredient)this, (GuiGraphics)draw, (int)x, (int)y);
        }
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)LText.translatable("tooltip.emi.accepts").m_7532_()));
        tooltip.add(EmiTooltipComponents.getIngredientTooltipComponent(this.ingredients));
        int item = (int)(System.currentTimeMillis() / 1000L % (long)this.ingredients.size());
        tooltip.addAll(this.ingredients.get(item).getTooltip());
        return tooltip;
    }
}

