/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.railwayteam.railways.content.custom_tracks.casing.CasingRenderUtils;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.mixin_interfaces.IMonorailBezier;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.client.ClientTextUtils;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackRenderer;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TrackRenderer.class}, remap=false)
public class MixinTrackRenderer {
    @Inject(method={"renderSafe(Lcom/simibubi/create/content/trains/track/TrackBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource;getBuffer(Lnet/minecraft/client/renderer/RenderType;)Lcom/mojang/blaze3d/vertex/VertexConsumer;")}, remap=true)
    private void renderCasing(TrackBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay, CallbackInfo ci) {
        SlabBlock casingBlock = ((IHasTrackCasing)te).getTrackCasing();
        if (casingBlock != null) {
            TrackShape shape = (TrackShape)te.m_58900_().m_61143_((Property)TrackBlock.SHAPE);
            if (CRBlockPartials.TRACK_CASINGS.containsKey(shape)) {
                ms.m_85836_();
                if (te.isTilted()) {
                    double angle = (Double)te.tilt.smoothingAngle.get();
                    switch ((TrackShape)te.m_58900_().m_61143_((Property)TrackBlock.SHAPE)) {
                        case ZO: {
                            TransformStack.cast((PoseStack)ms).rotateX(-angle);
                            break;
                        }
                        case XO: {
                            TransformStack.cast((PoseStack)ms).rotateZ(angle);
                        }
                    }
                }
                TrackMaterial.TrackType trackType = null;
                Block block = te.m_58900_().m_60734_();
                if (block instanceof TrackBlock) {
                    TrackBlock trackBlock = (TrackBlock)block;
                    trackType = trackBlock.getMaterial().trackType;
                }
                CRBlockPartials.TrackCasingSpec spec = CRBlockPartials.TRACK_CASINGS.get(shape);
                spec = ((IHasTrackCasing)te).isAlternate() ? spec.getNonNullAltSpec(trackType) : spec.getFor(trackType);
                CRBlockPartials.ModelTransform transform = spec.transform;
                PartialModel texturedPartial = CasingRenderUtils.reTexture(spec.model, casingBlock);
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)CasingRenderUtils.reTexture(spec.model, casingBlock), (BlockState)casingBlock.m_49966_()).rotateX((double)transform.rx())).rotateY((double)transform.ry())).rotateZ((double)transform.rz())).translate(transform.x(), transform.y(), transform.z()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
                for (CRBlockPartials.ModelTransform additionalTransform : spec.additionalTransforms) {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)texturedPartial, (BlockState)casingBlock.m_49966_()).rotateX((double)additionalTransform.rx())).rotateY((double)additionalTransform.ry())).rotateZ((double)additionalTransform.rz())).translate(additionalTransform.x(), additionalTransform.y(), additionalTransform.z()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
                }
                ms.m_85849_();
            } else {
                ClientTextUtils.renderDebugText(ms, buffer, light, 1.0, true, "No casing for shape " + shape);
            }
        }
    }

    @Inject(method={"renderBezierTurn"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V", remap=true)}, remap=false)
    private static void renderCurveCasings(Level level, BezierConnection bc, PoseStack ms, VertexConsumer vb, CallbackInfo ci) {
        SlabBlock casingBlock = ((IHasTrackCasing)bc).getTrackCasing();
        if (casingBlock != null) {
            CasingRenderUtils.renderBezierCasings(ms, level, CasingRenderUtils.reTexture(CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock), casingBlock.m_49966_(), vb, bc);
        }
    }

    @Inject(method={"renderBezierTurn"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/track/TrackRenderer;renderGirder(Lnet/minecraft/world/level/Level;Lcom/simibubi/create/content/trains/track/BezierConnection;Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/core/BlockPos;)V", shift=At.Shift.AFTER, remap=true)}, cancellable=true)
    private static void renderMonorailMaybe(Level level, BezierConnection bc, PoseStack ms, VertexConsumer vb, CallbackInfo ci) {
        if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
            MixinTrackRenderer.railways$renderActualMonorail(level, bc, ms, vb, (BlockPos)bc.tePositions.getFirst());
            ms.m_85849_();
            ci.cancel();
        }
    }

    @Unique
    private static void railways$renderActualMonorail(Level level, BezierConnection bc, PoseStack ms, VertexConsumer vb, BlockPos tePosition) {
        BlockState air = Blocks.f_50016_.m_49966_();
        IMonorailBezier.MonorailAngles[] monorails = ((IMonorailBezier)bc).getBakedMonorails();
        for (int i = 1; i < monorails.length; ++i) {
            IMonorailBezier.MonorailAngles segment = monorails[i];
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)segment.lightPosition.m_121955_((Vec3i)tePosition));
            PoseStack.Pose beamTransform = segment.beam;
            CachedBufferer.partial((PartialModel)CRBlockPartials.MONORAIL_SEGMENT_MIDDLE, (BlockState)air).mulPose(beamTransform.m_252922_()).mulNormal(beamTransform.m_252943_()).light(light).renderInto(ms, vb);
            for (boolean top : Iterate.trueAndFalse) {
                PoseStack.Pose beamCapTransform = (PoseStack.Pose)segment.beamCaps.get(top);
                CachedBufferer.partial((PartialModel)(top ? CRBlockPartials.MONORAIL_SEGMENT_TOP : CRBlockPartials.MONORAIL_SEGMENT_BOTTOM), (BlockState)air).mulPose(beamCapTransform.m_252922_()).mulNormal(beamCapTransform.m_252943_()).light(light).renderInto(ms, vb);
            }
        }
    }
}

