/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import io.github.foundationgames.automobility.item.SlopePlacementContext;
import io.github.foundationgames.automobility.util.AUtils;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SlopeBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final VoxelShape NORTH_BOTTOM_SHAPE;
    public static final VoxelShape SOUTH_BOTTOM_SHAPE;
    public static final VoxelShape EAST_BOTTOM_SHAPE;
    public static final VoxelShape WEST_BOTTOM_SHAPE;
    public static final VoxelShape NORTH_TOP_SHAPE;
    public static final VoxelShape SOUTH_TOP_SHAPE;
    public static final VoxelShape EAST_TOP_SHAPE;
    public static final VoxelShape WEST_TOP_SHAPE;
    public static final VoxelShape OLD_NORTH_BOTTOM_SHAPE;
    public static final VoxelShape OLD_SOUTH_BOTTOM_SHAPE;
    public static final VoxelShape OLD_EAST_BOTTOM_SHAPE;
    public static final VoxelShape OLD_WEST_BOTTOM_SHAPE;
    public static final VoxelShape OLD_NORTH_TOP_SHAPE;
    public static final VoxelShape OLD_SOUTH_TOP_SHAPE;
    public static final VoxelShape OLD_EAST_TOP_SHAPE;
    public static final VoxelShape OLD_WEST_TOP_SHAPE;
    public static final EnumProperty<Half> HALF;
    public static final BooleanProperty WATERLOGGED;
    protected final boolean old;

    public SlopeBlock(BlockBehaviour.Properties settings, boolean old) {
        super(settings);
        this.old = old;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState;
        if (ctx instanceof SlopePlacementContext) {
            SlopePlacementContext slopeCtx = (SlopePlacementContext)ctx;
            blockState = (BlockState)((BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)f_54117_, (Comparable)slopeCtx.getSlopeFacing())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_8055_(ctx.m_8083_()).m_60713_(Blocks.f_49990_)))).m_61124_(HALF, (Comparable)slopeCtx.getSlopeHalf());
        } else {
            blockState = (BlockState)((BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_8055_(ctx.m_8083_()).m_60713_(Blocks.f_49990_)))).m_61124_(HALF, (Comparable)(ctx.m_43720_().f_82480_ - (double)ctx.m_8083_().m_123342_() > 0.5 ? Half.TOP : Half.BOTTOM));
        }
        return blockState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, HALF, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.old) {
            return switch ((Half)state.m_61143_(HALF)) {
                case Half.BOTTOM -> {
                    switch ((Direction)state.m_61143_((Property)f_54117_)) {
                        case NORTH: {
                            yield OLD_NORTH_BOTTOM_SHAPE;
                        }
                        case SOUTH: {
                            yield OLD_SOUTH_BOTTOM_SHAPE;
                        }
                        case WEST: {
                            yield OLD_WEST_BOTTOM_SHAPE;
                        }
                        case EAST: {
                            yield OLD_EAST_BOTTOM_SHAPE;
                        }
                    }
                    yield Shapes.m_83040_();
                }
                case Half.TOP -> {
                    switch ((Direction)state.m_61143_((Property)f_54117_)) {
                        case NORTH: {
                            yield OLD_NORTH_TOP_SHAPE;
                        }
                        case SOUTH: {
                            yield OLD_SOUTH_TOP_SHAPE;
                        }
                        case WEST: {
                            yield OLD_WEST_TOP_SHAPE;
                        }
                        case EAST: {
                            yield OLD_EAST_TOP_SHAPE;
                        }
                    }
                    yield Shapes.m_83040_();
                }
                default -> Shapes.m_83040_();
            };
        }
        return switch ((Half)state.m_61143_(HALF)) {
            case Half.BOTTOM -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        yield NORTH_BOTTOM_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_BOTTOM_SHAPE;
                    }
                    case WEST: {
                        yield WEST_BOTTOM_SHAPE;
                    }
                    case EAST: {
                        yield EAST_BOTTOM_SHAPE;
                    }
                }
                yield Shapes.m_83040_();
            }
            case Half.TOP -> {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case NORTH: {
                        yield NORTH_TOP_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_TOP_SHAPE;
                    }
                    case WEST: {
                        yield WEST_TOP_SHAPE;
                    }
                    case EAST: {
                        yield EAST_TOP_SHAPE;
                    }
                }
                yield Shapes.m_83040_();
            }
            default -> Shapes.m_83040_();
        };
    }

    public static VoxelShape slopeStep(Direction dir, double height) {
        return switch (dir) {
            case Direction.NORTH -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)0.5);
            case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)height, (double)16.0);
            case Direction.EAST -> Block.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            case Direction.WEST -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)height, (double)16.0);
            default -> Shapes.m_83040_();
        };
    }

    static {
        double oz;
        double ox;
        int i;
        HALF = BlockStateProperties.f_61402_;
        WATERLOGGED = BlockStateProperties.f_61362_;
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (Direction dir : AUtils.HORIZONTAL_DIRS) {
            for (i = 0; i < 2; ++i) {
                ox = switch (dir) {
                    case Direction.WEST -> 0.5;
                    case Direction.EAST -> -0.5;
                    default -> 0.0;
                };
                oz = switch (dir) {
                    case Direction.NORTH -> 0.5;
                    case Direction.SOUTH -> -0.5;
                    default -> 0.0;
                };
                VoxelShape finalShape = Shapes.m_83040_();
                for (int j = 0; j < 32; ++j) {
                    finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)SlopeBlock.slopeStep(dir, (double)(i * 8) + (double)j * 0.25).m_83216_(ox * (double)j / 16.0, 0.0, oz * (double)j / 16.0));
                }
                shapes.add(finalShape);
            }
        }
        NORTH_BOTTOM_SHAPE = (VoxelShape)shapes.get(0);
        NORTH_TOP_SHAPE = (VoxelShape)shapes.get(1);
        SOUTH_BOTTOM_SHAPE = (VoxelShape)shapes.get(2);
        SOUTH_TOP_SHAPE = (VoxelShape)shapes.get(3);
        EAST_BOTTOM_SHAPE = (VoxelShape)shapes.get(4);
        EAST_TOP_SHAPE = (VoxelShape)shapes.get(5);
        WEST_BOTTOM_SHAPE = (VoxelShape)shapes.get(6);
        WEST_TOP_SHAPE = (VoxelShape)shapes.get(7);
        shapes.clear();
        for (Direction dir : AUtils.HORIZONTAL_DIRS) {
            for (i = 0; i < 2; ++i) {
                ox = switch (dir) {
                    case Direction.WEST -> 0.5;
                    case Direction.EAST -> -0.5;
                    default -> 0.0;
                };
                oz = switch (dir) {
                    case Direction.NORTH -> 0.5;
                    case Direction.SOUTH -> -0.5;
                    default -> 0.0;
                };
                VoxelShape shape = switch (dir) {
                    case Direction.NORTH -> Block.m_49796_((double)0.0, (double)-1.5, (double)0.0, (double)16.0, (double)0.5, (double)0.5);
                    case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)-1.5, (double)15.5, (double)16.0, (double)0.5, (double)16.0);
                    case Direction.EAST -> Block.m_49796_((double)15.5, (double)-1.5, (double)0.0, (double)16.0, (double)0.5, (double)16.0);
                    case Direction.WEST -> Block.m_49796_((double)0.0, (double)-1.5, (double)0.0, (double)0.5, (double)0.5, (double)16.0);
                    default -> Shapes.m_83040_();
                };
                VoxelShape finalShape = shape = shape.m_83216_(0.0, (double)i * 0.5, 0.0);
                for (int j = 1; j < 32; ++j) {
                    finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)shape.m_83216_(ox * (double)j / 16.0, 0.25 * (double)j / 16.0, oz * (double)j / 16.0));
                }
                shapes.add(finalShape);
            }
        }
        OLD_NORTH_BOTTOM_SHAPE = (VoxelShape)shapes.get(0);
        OLD_NORTH_TOP_SHAPE = (VoxelShape)shapes.get(1);
        OLD_SOUTH_BOTTOM_SHAPE = (VoxelShape)shapes.get(2);
        OLD_SOUTH_TOP_SHAPE = (VoxelShape)shapes.get(3);
        OLD_EAST_BOTTOM_SHAPE = (VoxelShape)shapes.get(4);
        OLD_EAST_TOP_SHAPE = (VoxelShape)shapes.get(5);
        OLD_WEST_BOTTOM_SHAPE = (VoxelShape)shapes.get(6);
        OLD_WEST_TOP_SHAPE = (VoxelShape)shapes.get(7);
    }
}

