/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.buttons;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.Button;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.SleepingBagItem;
import com.tiviacz.travelersbackpack.network.ServerboundSleepingBagPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class SleepingBagButton
extends Button {
    private final boolean isEquipped;

    public SleepingBagButton(BackpackScreen screen, boolean isEquipped, int xOffset) {
        super(screen, screen.getWidthAdditions() + 145 - xOffset, screen.getMiddleBar(), 12, 12);
        this.isEquipped = isEquipped;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS, 91, 83, 78, 82);
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.inButton(mouseX, mouseY)) {
            guiGraphics.m_280557_(this.screen.getFont(), (Component)Component.m_237115_((String)"screen.travelersbackpack.use_sleeping_bag"), mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.inButton((int)mouseX, (int)mouseY)) {
            if (this.isEquipped && this.screen.getWrapper().getBackpackOwner() == null) {
                return false;
            }
            PacketDistributorHelper.sendToServer(new ServerboundSleepingBagPacket(this.isEquipped ? this.screen.getWrapper().getBackpackOwner().m_20183_() : this.screen.getWrapper().getBackpackPos(), this.isEquipped));
            return true;
        }
        return false;
    }

    public ItemStack getSleepingBagItemFromColor(int colorId) {
        return switch (colorId) {
            case 0 -> ((SleepingBagItem)((Object)ModItems.WHITE_SLEEPING_BAG.get())).m_7968_();
            case 1 -> ((SleepingBagItem)((Object)ModItems.ORANGE_SLEEPING_BAG.get())).m_7968_();
            case 2 -> ((SleepingBagItem)((Object)ModItems.MAGENTA_SLEEPING_BAG.get())).m_7968_();
            case 3 -> ((SleepingBagItem)((Object)ModItems.LIGHT_BLUE_SLEEPING_BAG.get())).m_7968_();
            case 4 -> ((SleepingBagItem)((Object)ModItems.YELLOW_SLEEPING_BAG.get())).m_7968_();
            case 5 -> ((SleepingBagItem)((Object)ModItems.LIME_SLEEPING_BAG.get())).m_7968_();
            case 6 -> ((SleepingBagItem)((Object)ModItems.PINK_SLEEPING_BAG.get())).m_7968_();
            case 7 -> ((SleepingBagItem)((Object)ModItems.GRAY_SLEEPING_BAG.get())).m_7968_();
            case 8 -> ((SleepingBagItem)((Object)ModItems.LIGHT_GRAY_SLEEPING_BAG.get())).m_7968_();
            case 9 -> ((SleepingBagItem)((Object)ModItems.CYAN_SLEEPING_BAG.get())).m_7968_();
            case 10 -> ((SleepingBagItem)((Object)ModItems.PURPLE_SLEEPING_BAG.get())).m_7968_();
            case 11 -> ((SleepingBagItem)((Object)ModItems.BLUE_SLEEPING_BAG.get())).m_7968_();
            case 12 -> ((SleepingBagItem)((Object)ModItems.BROWN_SLEEPING_BAG.get())).m_7968_();
            case 13 -> ((SleepingBagItem)((Object)ModItems.GREEN_SLEEPING_BAG.get())).m_7968_();
            case 15 -> ((SleepingBagItem)((Object)ModItems.BLACK_SLEEPING_BAG.get())).m_7968_();
            default -> ((SleepingBagItem)((Object)ModItems.RED_SLEEPING_BAG.get())).m_7968_();
        };
    }
}

