/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemStackHandler;

public class UnpackCommand {
    public UnpackCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"tb").requires(player -> player.m_6761_(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unpack").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(source -> this.unpackTargetBlockEntity((CommandSourceStack)source.getSource(), BlockPosArgument.m_118242_((CommandContext)source, (String)"pos"))))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(source -> this.unpackTargetInventory((CommandSourceStack)source.getSource(), EntityArgument.m_91474_((CommandContext)source, (String)"target")))));
        dispatcher.register(tbCommand);
    }

    public int unpackTargetBlockEntity(CommandSourceStack source, BlockPos blockPos) {
        BlockEntity blockEntity = source.m_81372_().m_7702_(blockPos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
            NonNullList<ItemStack> stacks = this.collectItems(blockEntity2.getWrapper());
            if (!stacks.isEmpty()) {
                if (!source.m_81372_().f_46443_) {
                    Containers.m_19010_((Level)source.m_81372_(), (BlockPos)blockPos, stacks);
                }
                source.m_288197_(() -> Component.m_237113_((String)("Dropping contents of backpack placed at " + blockPos.m_123344_())), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)("There's no contents in backpack at coordinates " + blockPos.m_123344_())));
            return -1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("There's no backpack at coordinates " + blockPos.m_123344_())));
        return -1;
    }

    public int unpackTargetInventory(CommandSourceStack source, ServerPlayer serverPlayer) {
        boolean hasBackpack = CapabilityUtils.isWearingBackpack((Player)serverPlayer);
        if (TravelersBackpack.enableIntegration()) {
            return -1;
        }
        if (hasBackpack) {
            AtomicBoolean flag = new AtomicBoolean(false);
            CapabilityUtils.getCapability((Player)serverPlayer).ifPresent(data -> {
                NonNullList<ItemStack> stacks = this.collectItems(data.getWrapper());
                if (!stacks.isEmpty() && !source.m_81372_().f_46443_) {
                    data.synchronise();
                    Containers.m_19010_((Level)source.m_81372_(), (BlockPos)serverPlayer.m_20183_(), stacks);
                    flag.set(true);
                }
            });
            if (flag.get()) {
                source.m_288197_(() -> Component.m_237113_((String)("Dropping contents of " + serverPlayer.m_5446_().getString() + " backpack at " + serverPlayer.m_20183_().m_123344_())), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)("There's no contents in " + serverPlayer.m_5446_().getString() + " backpack")));
            return -1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("Player " + serverPlayer.m_5446_().getString() + " is not wearing backpack")));
        return -1;
    }

    public NonNullList<ItemStack> collectItems(BackpackWrapper wrapper) {
        NonNullList stacks = NonNullList.m_122779_();
        stacks.addAll(this.collectItems(wrapper.getStorage()));
        stacks.addAll(this.collectItems(wrapper.getTools()));
        stacks.addAll(this.collectItems(wrapper.getUpgrades()));
        return stacks;
    }

    public NonNullList<ItemStack> collectItems(ItemStackHandler handler) {
        NonNullList stacks = NonNullList.m_122779_();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stackInSlot = handler.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            stacks.add((Object)stackInSlot);
            handler.setStackInSlot(i, ItemStack.f_41583_);
        }
        return stacks;
    }
}

