/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.crafting;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.CraftingSlot;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ResultSlotExt;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingContainerImprovedNew;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;

public class CraftingUpgrade
extends UpgradeBase {
    public ItemStackHandler crafting;
    public ResultContainer resultSlots;
    public CraftingContainerImprovedNew craftSlots;

    public CraftingUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> craftingContents) {
        super(manager, dataHolderSlot, new Point(66, 112));
        this.crafting = this.createHandler(craftingContents);
    }

    public boolean shiftClickToBackpack() {
        return NbtHelper.getOrDefault(this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot), "ShiftClickToBackpack", false);
    }

    @Override
    public void remove() {
        this.upgradeManager.craftingUpgrade = Optional.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase createWidget(BackpackScreen screen, int x, int y) {
        return new CraftingWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public void initializeContainers(BackpackBaseMenu menu, BackpackWrapper wrapper) {
        this.craftSlots = new CraftingContainerImprovedNew(menu, this);
        this.resultSlots = new ResultContainer();
    }

    public List<Slot> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        menu.CRAFTING_GRID_START = menu.f_38839_.size();
        menu.CRAFTING_RESULT = menu.f_38839_.size() + 9;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                slots.add(new CraftingSlot((Container)this.craftSlots, j + i * 3, x + 7 + j * 18, y + 23 + i * 18){

                    public boolean m_6659_() {
                        return CraftingUpgrade.this.isTabOpened();
                    }

                    public boolean m_5857_(ItemStack pStack) {
                        return true;
                    }

                    public boolean m_8010_(Player pPlayer) {
                        return true;
                    }
                });
            }
        }
        slots.add((Slot)new ResultSlotExt(wrapper, menu.player, this.craftSlots, this.resultSlots, 0, x + 25, y + 89){

            @Override
            public boolean m_8010_(Player player) {
                return CraftingUpgrade.this.isTabOpened();
            }

            @Override
            public boolean m_6659_() {
                return CraftingUpgrade.this.isTabOpened();
            }
        });
        return slots;
    }

    public void setSlotChanged(ItemStack dataHolderStack, int index, ItemStack stack) {
        NbtHelper.update(dataHolderStack, "Inventory", 9, index, stack);
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                ItemStack stack = CraftingUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(CraftingUpgrade.this.getDataHolderSlot());
                CraftingUpgrade.this.setSlotChanged(stack, slot, this.getStackInSlot(slot));
                CraftingUpgrade.this.getUpgradeManager().getUpgradesHandler().setStackInSlot(CraftingUpgrade.this.getDataHolderSlot(), stack);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return BackpackSlotItemHandler.isItemValid(stack);
            }
        };
    }
}

