/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.jukebox;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class JukeboxUpgrade
extends UpgradeBase {
    public ItemStackHandler diskHandler;

    public JukeboxUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> musicDiskContents) {
        super(manager, dataHolderSlot, new Point(66, 46));
        this.diskHandler = this.createHandler(musicDiskContents);
    }

    @Override
    public void remove() {
        this.upgradeManager.jukeboxUpgrade = Optional.empty();
    }

    @Override
    public void onUpgradeRemoved(ItemStack removedStack) {
        NbtHelper.set(removedStack, "IsPlaying", false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase createWidget(BackpackScreen screen, int x, int y) {
        return new JukeboxWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    public List<Slot> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        slots.add((Slot)new SlotItemHandler((IItemHandler)this.diskHandler, 0, x + 7, y + 23){

            public boolean m_6659_() {
                return JukeboxUpgrade.this.isTabOpened();
            }

            public boolean m_5857_(ItemStack pStack) {
                return JukeboxUpgrade.this.isTabOpened() && NbtHelper.getOrDefault(JukeboxUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(JukeboxUpgrade.this.getDataHolderSlot()), "IsPlaying", false) == false;
            }

            public boolean m_8010_(Player playerIn) {
                return super.m_8010_(playerIn) && NbtHelper.getOrDefault(JukeboxUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(JukeboxUpgrade.this.getDataHolderSlot()), "IsPlaying", false) == false;
            }
        });
        return slots;
    }

    public boolean isPlayingRecord() {
        return NbtHelper.getOrDefault(this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot), "IsPlaying", false);
    }

    public boolean canPlayRecord() {
        return !this.isPlayingRecord() && !this.diskHandler.getStackInSlot(0).m_41619_();
    }

    public void setSlotChanged(ItemStack dataHolderStack, int index, ItemStack stack) {
        NbtHelper.update(dataHolderStack, "Inventory", 1, index, stack);
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                ItemStack stack = JukeboxUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(JukeboxUpgrade.this.getDataHolderSlot());
                JukeboxUpgrade.this.setSlotChanged(stack, slot, this.getStackInSlot(slot));
                JukeboxUpgrade.this.getUpgradeManager().getUpgradesHandler().setStackInSlot(JukeboxUpgrade.this.getDataHolderSlot(), stack);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof RecordItem;
            }
        };
    }
}

