/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.inventory.SlotPositioner;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundFillTankPacket;
import com.tiviacz.travelersbackpack.util.FluidStackHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TankWidget
extends UpgradeWidgetBase<TanksUpgrade> {
    public final int tankWidth = 18;
    public final int tankHeight;
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TankWidget(BackpackScreen screen, TanksUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(0, 0), "screen.travelersbackpack.tanks_upgrade");
        this.tankHeight = 18 * screen.visibleRows;
        this.leftTankPos = upgrade.leftTankPos;
        this.rightTankPos = upgrade.rightTankPos;
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.inTank(this.leftTankPos, mouseX, mouseY)) {
            guiGraphics.m_280666_(((BackpackScreen)this.screen).getFont(), this.getTankTooltip(((TanksUpgrade)this.upgrade).leftTank), mouseX, mouseY);
        }
        if (this.inTank(this.rightTankPos, mouseX, mouseY)) {
            guiGraphics.m_280666_(((BackpackScreen)this.screen).getFont(), this.getTankTooltip(((TanksUpgrade)this.upgrade).rightTank), mouseX, mouseY);
        }
    }

    @Override
    public void renderAboveBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        SlotPositioner pos = ((TanksUpgrade)this.upgrade).getUpgradeManager().getWrapper().getSlotPositioner();
        int extendedOffset = 0;
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).leftTank, x + 8, (y += 10) + 8, 0.0, (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) * 18 - 2, 16.0);
        this.renderTank(guiGraphics, pos, x + 7, y);
        if (pos.isExtended()) {
            extendedOffset = 36;
        }
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).rightTank, x + 196 + extendedOffset, y + 8, 0.0, (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) * 18 - 2, 16.0);
        this.renderTank(guiGraphics, pos, x + 195 + extendedOffset, y);
    }

    @Override
    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.inTank(this.leftTankPos, (int)pMouseX, (int)pMouseY) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).m_6262_()).m_142621_())) {
            PacketDistributorHelper.sendToServer(new ServerboundFillTankPacket(true));
            return true;
        }
        if (this.inTank(this.rightTankPos, (int)pMouseX, (int)pMouseY) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).m_6262_()).m_142621_())) {
            PacketDistributorHelper.sendToServer(new ServerboundFillTankPacket(false));
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean isValid(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).isPresent() || stack.m_41720_() instanceof PotionItem || stack.m_41720_() == Items.f_42590_;
    }

    public void renderTank(GuiGraphics guiGraphics, SlotPositioner pos, int x, int y) {
        guiGraphics.m_280218_(BackpackScreen.ICONS, x, y + 7, 0, 95, 18, 18);
        for (int i = 1; i <= (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) - 2; ++i) {
            guiGraphics.m_280218_(BackpackScreen.ICONS, x, y + 7 + 18 * i, 0, 113, 18, 18);
        }
        guiGraphics.m_280218_(BackpackScreen.ICONS, x, y + 7 + 18 * ((((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : pos.getRows()) - 1), 0, 131, 18, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTankTooltip(FluidTank tank) {
        Object fluidAmount;
        FluidStack fluidStack = tank.getFluid();
        ArrayList<Component> tankTips = new ArrayList<Component>();
        String fluidName = !fluidStack.isEmpty() ? fluidStack.getFluid().getFluidType().getDescription().getString() : I18n.m_118938_((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        Object object = fluidAmount = !fluidStack.isEmpty() ? fluidStack.getAmount() + "/" + tank.getCapacity() : I18n.m_118938_((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidStack.isEmpty() && fluidStack.getTag() != null) {
            float durationFactor = 1.0f;
            if (fluidStack.getTag().m_128441_("Splash")) {
                tankTips.add((Component)Component.m_237115_((String)"item.minecraft.splash_potion"));
            }
            if (fluidStack.getTag().m_128441_("Lingering")) {
                tankTips.add((Component)Component.m_237115_((String)"item.minecraft.lingering_potion"));
                durationFactor = 0.25f;
            }
            if (fluidStack.getTag().m_128441_("Potion")) {
                fluidName = null;
                TankWidget.setPotionDescription(FluidStackHelper.getItemStackFromFluidStack(fluidStack), tankTips, durationFactor);
            }
        }
        if (fluidName != null) {
            tankTips.add((Component)Component.m_237113_((String)fluidName));
        }
        tankTips.add((Component)Component.m_237113_((String)fluidAmount));
        return tankTips;
    }

    public boolean inTank(Point tankPos, int mouseX, int mouseY) {
        return ((BackpackScreen)this.screen).getGuiLeft() + tankPos.x() <= mouseX && mouseX <= tankPos.x() + this.tankWidth + ((BackpackScreen)this.screen).getGuiLeft() && tankPos.y() + ((BackpackScreen)this.screen).getGuiTop() <= mouseY && mouseY <= tankPos.y() + this.tankHeight + ((BackpackScreen)this.screen).getGuiTop();
    }

    public static void setPotionDescription(ItemStack stack, List<Component> componentList, float durationFactor) {
        List list = PotionUtils.m_43547_((ItemStack)stack);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            componentList.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance mobeffectinstance : list) {
                MutableComponent mutablecomponent = Component.m_237115_((String)mobeffectinstance.m_19576_());
                MobEffect mobeffect = mobeffectinstance.m_19544_();
                Map map = mobeffect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), mobeffect.m_7048_(mobeffectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (mobeffectinstance.m_19564_() > 0) {
                    mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + mobeffectinstance.m_19564_()))});
                }
                if (mobeffectinstance.m_19557_() > 20) {
                    mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)mobeffectinstance, (float)durationFactor)});
                }
                componentList.add((Component)mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            componentList.add(CommonComponents.f_237098_);
            componentList.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    componentList.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                componentList.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

