/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FluidSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TankWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class TanksUpgrade
extends UpgradeBase {
    private final ItemStackHandler fluidSlotsHandler = this.createTemporaryHandler();
    protected final FluidTank leftTank = this.createFluidHandler(1000);
    protected final FluidTank rightTank = this.createFluidHandler(1000);
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TanksUpgrade(UpgradeManager manager, int dataHolderSlot, Fluids fluids) {
        super(manager, dataHolderSlot, new Point(51, 72));
        this.setTanksCapacity();
        this.setFluids(fluids);
        this.leftTankPos = new Point(7, 15);
        this.rightTankPos = new Point(195 + (manager.getWrapper().getSlotPositioner().isExtended() ? 36 : 0), 15);
        this.getUpgradeManager().getWrapper().setRenderInfo(this.writeToRenderData());
    }

    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public ItemStackHandler getFluidSlotsHandler() {
        return this.fluidSlotsHandler;
    }

    public void setTanksCapacity() {
        this.leftTank.setCapacity(this.getUpgradeManager().getWrapper().getBackpackTankCapacity());
        this.rightTank.setCapacity(this.getUpgradeManager().getWrapper().getBackpackTankCapacity());
    }

    public void setFluids(Fluids tanks) {
        this.leftTank.setFluid(tanks.leftFluidStack());
        this.rightTank.setFluid(tanks.rightFluidStack());
    }

    public void syncClients(ItemStack backpack) {
        int slot = this.getDataHolderSlot();
        NonNullList contents = (NonNullList)NbtHelper.get(backpack, "Upgrades");
        if (contents == null) {
            return;
        }
        if (slot >= contents.size()) {
            return;
        }
        ItemStack stack = (ItemStack)contents.get(slot);
        this.setFluids(NbtHelper.getOrDefault(stack, "Fluids", Fluids.empty()));
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                ItemStack stack = TanksUpgrade.this.getUpgradeManager().getUpgradesHandler().getStackInSlot(TanksUpgrade.this.getDataHolderSlot());
                NbtHelper.set(stack, "Fluids", new Fluids(TanksUpgrade.this.leftTank.getFluid(), TanksUpgrade.this.rightTank.getFluid()));
                TanksUpgrade.this.getUpgradeManager().getUpgradesHandler().setStackInSlot(TanksUpgrade.this.getDataHolderSlot(), stack);
                TanksUpgrade.this.getUpgradeManager().getWrapper().setRenderInfo(TanksUpgrade.this.writeToRenderData());
                TanksUpgrade.this.getUpgradeManager().getWrapper().sendDataToClients("RenderInfo", "Upgrades");
            }
        };
    }

    public CompoundTag writeToRenderData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("LeftTank", (Tag)this.leftTank.getFluid().writeToNBT(new CompoundTag()));
        tag.m_128365_("RightTank", (Tag)this.rightTank.getFluid().writeToNBT(new CompoundTag()));
        tag.m_128405_("Capacity", this.leftTank.getCapacity());
        return tag;
    }

    @Override
    public void remove() {
        this.getUpgradeManager().tanksUpgrade = Optional.empty();
        this.getUpgradeManager().getWrapper().removeRenderInfo();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase createWidget(BackpackScreen screen, int x, int y) {
        return new TankWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    public List<SlotItemHandler> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<SlotItemHandler> slots = new ArrayList<SlotItemHandler>();
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 0, x + 7, y + 23));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 1, x + 7, y + 49));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 2, x + 28, y + 23));
        slots.add(new FluidSlotItemHandler(menu.player, this, wrapper, this.getFluidSlotsHandler(), 3, x + 28, y + 49));
        return slots;
    }

    public ItemStackHandler createTemporaryHandler() {
        return new ItemStackHandler(4){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                LazyOptional container = FluidUtil.getFluidHandler((ItemStack)stack);
                if (slot == 1 || slot == 3) {
                    return false;
                }
                if (stack.m_41720_() instanceof PotionItem || stack.m_41720_() == Items.f_42590_) {
                    return true;
                }
                return container.isPresent();
            }
        };
    }
}

