/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundFilterSettingsPacket {
    private final int slot;
    private final List<Integer> settings;

    public ServerboundFilterSettingsPacket(int slot, List<Integer> settings) {
        this.slot = slot;
        this.settings = settings;
    }

    public static ServerboundFilterSettingsPacket decode(FriendlyByteBuf buffer) {
        int slot = buffer.readInt();
        List<Integer> settings = buffer.m_178338_().intStream().boxed().collect(Collectors.toList());
        return new ServerboundFilterSettingsPacket(slot, settings);
    }

    public static void encode(ServerboundFilterSettingsPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slot);
        buffer.m_178345_((IntList)new IntArrayList(message.settings.stream().mapToInt(Integer::intValue).toArray()));
    }

    public static void handle(ServerboundFilterSettingsPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player instanceof ServerPlayer) {
                BackpackBaseMenu menu;
                BackpackWrapper wrapper;
                ServerPlayer serverPlayer = player;
                AbstractContainerMenu patt2175$temp = serverPlayer.f_36096_;
                if (patt2175$temp instanceof BackpackBaseMenu && !(wrapper = (menu = (BackpackBaseMenu)patt2175$temp).getWrapper()).getUpgrades().getStackInSlot(message.slot).m_41619_()) {
                    IUpgrade patt2848$temp;
                    ItemStack upgradeStack = wrapper.getUpgrades().getStackInSlot(message.slot).m_41777_();
                    NbtHelper.set(upgradeStack, "FilterSettings", message.settings);
                    wrapper.getUpgrades().setStackInSlot(message.slot, upgradeStack);
                    if (wrapper.getUpgradeManager().mappedUpgrades.get(message.slot).isPresent() && (patt2848$temp = wrapper.getUpgradeManager().mappedUpgrades.get(message.slot).get()) instanceof IFilter) {
                        IFilter filter = (IFilter)((Object)patt2848$temp);
                        filter.updateSettings();
                    }
                    menu.getWrapper().saveHandler.run();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

