/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.common.ServerActions;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSleepingBagPacket {
    private final BlockPos pos;
    private final boolean isEquipped;

    public ServerboundSleepingBagPacket(BlockPos pos, boolean isEquipped) {
        this.pos = pos;
        this.isEquipped = isEquipped;
    }

    public static ServerboundSleepingBagPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        boolean isEquipped = buffer.readBoolean();
        return new ServerboundSleepingBagPacket(pos, isEquipped);
    }

    public static void encode(ServerboundSleepingBagPacket message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.writeBoolean(message.isEquipped);
    }

    public static void handle(ServerboundSleepingBagPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                ServerActions.toggleSleepingBag((Player)serverPlayer, message.pos, message.isEquipped);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

