/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emitrades.config;

import io.github.prismwork.emitrades.EMITradesPlugin;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonWriter;

public class EMITradesConfig {
    public static Config load(File file) {
        if (!file.getName().endsWith(".json5")) {
            throw new RuntimeException("Failed to read config");
        }
        Config cfg = null;
        if (file.exists()) {
            Config config;
            block18: {
                JsonReader reader = JsonReader.json5((Path)file.toPath());
                try {
                    cfg = new Config();
                    reader.beginObject();
                    block13: while (reader.hasNext()) {
                        String nextName;
                        switch (nextName = reader.nextName()) {
                            case "enable3DVillagerModelInRecipes": {
                                cfg.enable3DVillagerModelInRecipes = reader.nextBoolean();
                                continue block13;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    config = cfg;
                    if (reader == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        EMITradesPlugin.LOGGER.error("Failed to parse config", (Throwable)e);
                    }
                }
                reader.close();
            }
            return config;
        }
        if (cfg == null) {
            cfg = new Config();
        }
        EMITradesConfig.save(file, cfg);
        return cfg;
    }

    public static void save(File file, Config cfg) {
        try (JsonWriter writer = JsonWriter.json5((Path)file.toPath());){
            writer.beginObject();
            writer.comment("Declares whether the villager entity model is shown in the recipe UI.").name("enable3DVillagerModelInRecipes").value(cfg.enable3DVillagerModelInRecipes);
            writer.endObject();
        }
        catch (IOException e) {
            EMITradesPlugin.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static class Config {
        public boolean enable3DVillagerModelInRecipes = true;
    }
}

