/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit;

import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.api.misc.ColorControl;
import com.enderio.api.misc.RedstoneControl;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public interface ConduitNode<T extends ConduitData<T>> {
    public Optional<IOState> getIOState(Direction var1);

    public BlockPos getPos();

    public T getConduitData();

    @Nullable
    public ConduitUpgrade getUpgrade(Direction var1);

    @Nullable
    public ResourceFilter getExtractFilter(Direction var1);

    @Nullable
    public ResourceFilter getInsertFilter(Direction var1);

    @Nullable
    public ConduitGraph<T> getParentGraph();

    public record IOState(Optional<ColorControl> insert, Optional<ColorControl> extract, RedstoneControl control, ColorControl redstoneChannel) {
        public boolean isInsert() {
            return this.insert().isPresent();
        }

        public boolean isExtract() {
            return this.extract().isPresent();
        }

        public static IOState of(@Nullable ColorControl in, @Nullable ColorControl extract, RedstoneControl control, ColorControl redstoneChannel) {
            return new IOState(Optional.ofNullable(in), Optional.ofNullable(extract), control, redstoneChannel);
        }
    }
}

