/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit.ticker;

import com.enderio.api.conduit.ColoredRedstoneProvider;
import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitNode;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ticker.LoadedAwareConduitTicker;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.api.misc.ColorControl;
import com.enderio.api.misc.RedstoneControl;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.Nullable;

public interface IOAwareConduitTicker<T extends ConduitData<T>>
extends LoadedAwareConduitTicker<T> {
    @Override
    default public void tickGraph(ServerLevel level, ConduitType<T> type, List<ConduitNode<T>> loadedNodes, ConduitGraph<T> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        ArrayListMultimap extracts = ArrayListMultimap.create();
        ArrayListMultimap inserts = ArrayListMultimap.create();
        for (ConduitNode<T> node : loadedNodes) {
            for (Direction direction : Direction.values()) {
                node.getIOState(direction).ifPresent(arg_0 -> this.lambda$tickGraph$3(type, level, node, coloredRedstoneProvider, (ListMultimap)extracts, direction, (ListMultimap)inserts, arg_0));
            }
        }
        for (ColorControl color : ColorControl.values()) {
            List insertList;
            List extractList = extracts.get((Object)color);
            if (this.shouldSkipColor(extractList, insertList = inserts.get((Object)color))) continue;
            this.tickColoredGraph(level, type, insertList, extractList, color, graph, coloredRedstoneProvider);
        }
    }

    default public boolean shouldSkipColor(List<Connection<T>> extractList, List<Connection<T>> insertList) {
        return extractList.isEmpty() || insertList.isEmpty();
    }

    public void tickColoredGraph(ServerLevel var1, ConduitType<T> var2, List<Connection<T>> var3, List<Connection<T>> var4, ColorControl var5, ConduitGraph<T> var6, ColoredRedstoneProvider var7);

    default public boolean isRedstoneMode(ConduitType<?> type, ServerLevel level, BlockPos pos, ConduitNode.IOState state, ColoredRedstoneProvider coloredRedstoneProvider) {
        if (!type.getMenuData().showRedstoneExtract()) {
            return true;
        }
        if (state.control() == RedstoneControl.ALWAYS_ACTIVE) {
            return true;
        }
        if (state.control() == RedstoneControl.NEVER_ACTIVE) {
            return false;
        }
        boolean hasRedstone = false;
        for (Direction direction : Direction.values()) {
            if (level.m_277185_(pos.m_121945_(direction), direction) <= 0) continue;
            hasRedstone = true;
            break;
        }
        return state.control().isActive(hasRedstone || coloredRedstoneProvider.isRedstoneActive(level, pos, state.redstoneChannel()));
    }

    private /* synthetic */ void lambda$tickGraph$3(ConduitType type, ServerLevel level, ConduitNode node, ColoredRedstoneProvider coloredRedstoneProvider, ListMultimap extracts, Direction direction, ListMultimap inserts, ConduitNode.IOState ioState) {
        ioState.extract().filter(extract -> this.isRedstoneMode(type, level, node.getPos(), ioState, coloredRedstoneProvider)).ifPresent(color -> extracts.get(color).add(new Connection(node.getPos(), direction, node.getConduitData(), node.getUpgrade(direction), node.getExtractFilter(direction), node.getInsertFilter(direction))));
        ioState.insert().ifPresent(color -> inserts.get(color).add(new Connection(node.getPos(), direction, node.getConduitData(), node.getUpgrade(direction), node.getExtractFilter(direction), node.getInsertFilter(direction))));
    }

    public record Connection<T extends ConduitData<T>>(BlockPos pos, Direction dir, T data, @Nullable ConduitUpgrade upgrade, @Nullable ResourceFilter extractFilter, @Nullable ResourceFilter insertFilter) {
        public BlockPos move() {
            return this.pos.m_121945_(this.dir);
        }
    }
}

