/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.block.light;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Light
extends FaceAttachedHorizontalDirectionalBlock {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    protected static final VoxelShape CEILING_AABB_X = Block.m_49796_((double)6.0, (double)14.0, (double)5.0, (double)10.0, (double)16.0, (double)11.0);
    protected static final VoxelShape CEILING_AABB_Z = Block.m_49796_((double)5.0, (double)14.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0);
    protected static final VoxelShape FLOOR_AABB_X = Block.m_49796_((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)2.0, (double)11.0);
    protected static final VoxelShape FLOOR_AABB_Z = Block.m_49796_((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)2.0, (double)10.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)5.0, (double)6.0, (double)14.0, (double)11.0, (double)10.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)5.0, (double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)2.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)14.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0, (double)11.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)6.0, (double)5.0, (double)2.0, (double)10.0, (double)11.0);
    private final boolean inverted;

    public Light(BlockBehaviour.Properties properties, boolean inverted) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(!inverted))).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL));
        this.inverted = inverted;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, ENABLED, f_53179_});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                if (direction.m_122434_() == Direction.Axis.X) {
                    return FLOOR_AABB_X;
                }
                return FLOOR_AABB_Z;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return EAST_AABB;
                    }
                    case WEST: {
                        return WEST_AABB;
                    }
                    case SOUTH: {
                        return SOUTH_AABB;
                    }
                }
                return NORTH_AABB;
            }
        }
        if (direction.m_122434_() == Direction.Axis.X) {
            return CEILING_AABB_X;
        }
        return CEILING_AABB_Z;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return true;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.checkPoweredState(level, pos, state);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.checkPoweredState(level, pos, state);
        }
    }

    public void checkPoweredState(Level level, BlockPos pos, BlockState state) {
        boolean powered = level.m_276867_(pos);
        if (powered != this.inverted ? (Boolean)state.m_61143_((Property)ENABLED) != false : (Boolean)state.m_61143_((Property)ENABLED) == false) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(this.inverted ? powered : !powered)), 3);
        }
    }
}

