/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.capacitor;

import com.enderio.EnderIO;
import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.capacitor.ICapacitorData;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public final class LootCapacitorData
implements ICapacitorData {
    private final ItemStack stack;
    private static final String KEY_BASE = "Base";
    private static final String KEY_MODIFIER_ARRAY = "Modifiers";

    public LootCapacitorData(ItemStack stack) {
        this(stack, 1.0f, new HashMap<CapacitorModifier, Float>());
    }

    public LootCapacitorData(ItemStack stack, float base, Map<CapacitorModifier, Float> specializations) {
        this.stack = stack;
        CompoundTag tag = this.stack.m_41784_();
        CompoundTag nbt = new CompoundTag();
        if (!tag.m_128441_("CapacitorData")) {
            nbt.m_128350_(KEY_BASE, base);
            CompoundTag modifiers = new CompoundTag();
            specializations.forEach((s, l) -> modifiers.m_128350_(s.name(), l.floatValue()));
            nbt.m_128365_(KEY_MODIFIER_ARRAY, (Tag)modifiers);
            tag.m_128365_("CapacitorData", (Tag)nbt);
        }
    }

    @Override
    public float getBase() {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("CapacitorData") && tag.m_128469_("CapacitorData").m_128441_(KEY_BASE)) {
            return tag.m_128469_("CapacitorData").m_128457_(KEY_BASE);
        }
        return 0.0f;
    }

    public void setBase(float base) {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("CapacitorData")) {
            tag.m_128469_("CapacitorData").m_128350_(KEY_BASE, base);
        }
    }

    @Override
    public float getModifier(CapacitorModifier modifier) {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("CapacitorData") && tag.m_128469_("CapacitorData").m_128441_(KEY_MODIFIER_ARRAY) && tag.m_128469_("CapacitorData").m_128469_(KEY_MODIFIER_ARRAY).m_128441_(modifier.name())) {
            return tag.m_128469_("CapacitorData").m_128469_(KEY_MODIFIER_ARRAY).m_128457_(modifier.name());
        }
        return this.getBase();
    }

    @Override
    public Map<CapacitorModifier, Float> getAllModifiers() {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("CapacitorData") && tag.m_128469_("CapacitorData").m_128441_(KEY_MODIFIER_ARRAY)) {
            CompoundTag modifiers = tag.m_128469_("CapacitorData").m_128469_(KEY_MODIFIER_ARRAY);
            try {
                return modifiers.m_128431_().stream().collect(Collectors.toMap(CapacitorModifier::valueOf, arg_0 -> ((CompoundTag)modifiers).m_128457_(arg_0)));
            }
            catch (NumberFormatException ex) {
                EnderIO.LOGGER.error("Loaded an invalid capacitor modifier key from item NBT! Capacitor reset.");
            }
        }
        return Map.of();
    }

    public void addModifier(CapacitorModifier modifier, float level) {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("CapacitorData") && tag.m_128469_("CapacitorData").m_128441_(KEY_MODIFIER_ARRAY)) {
            tag.m_128469_("CapacitorData").m_128469_(KEY_MODIFIER_ARRAY).m_128350_(modifier.name(), level);
        }
    }

    public void addNewModifier(CapacitorModifier modifier, float level) {
        CompoundTag tag = this.stack.m_41784_();
        if (tag.m_128441_("CapacitorData")) {
            tag.m_128469_("CapacitorData").m_128365_(KEY_MODIFIER_ARRAY, (Tag)new CompoundTag());
        }
        this.addModifier(modifier, level);
    }

    public void addAllModifiers(Map<CapacitorModifier, Float> specializations) {
        for (Map.Entry<CapacitorModifier, Float> entry : specializations.entrySet()) {
            this.addModifier(entry.getKey(), entry.getValue().floatValue());
        }
    }
}

