/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.enchantment;

import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.enchantment.EIOBaseEnchantment;
import com.enderio.core.common.util.TeleportUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class RepellentEnchantment
extends EIOBaseEnchantment {
    public RepellentEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.ARMOR, new EquipmentSlot[]{EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}, () -> true);
    }

    public int m_6586_() {
        return (Integer)BaseConfig.COMMON.ENCHANTMENTS.REPELLENT_MAX_LEVEL.get();
    }

    public int m_6175_(int pLevel) {
        return (Integer)BaseConfig.COMMON.ENCHANTMENTS.REPELLENT_MAX_COST_BASE.get() + (Integer)BaseConfig.COMMON.ENCHANTMENTS.REPELLENT_MAX_COST_MULT.get() * pLevel;
    }

    public int m_6183_(int pLevel) {
        return (Integer)BaseConfig.COMMON.ENCHANTMENTS.REPELLENT_MIN_COST_BASE.get() + (Integer)BaseConfig.COMMON.ENCHANTMENTS.REPELLENT_MIN_COST_MULT.get() * pLevel;
    }

    private float getChance(int level) {
        return ((Double)BaseConfig.COMMON.ENCHANTMENTS.REPELLENT_CHANCE_BASE.get()).floatValue() + ((Double)BaseConfig.COMMON.ENCHANTMENTS.REPELLENT_CHANCE_MULT.get()).floatValue() * (float)level;
    }

    private double getRange(int level) {
        return (Double)BaseConfig.COMMON.ENCHANTMENTS.REPELLENT_RANGE_BASE.get() + (Double)BaseConfig.COMMON.ENCHANTMENTS.REPELLENT_RANGE_MULT.get() * (double)level;
    }

    public void m_7675_(LivingEntity pUser, Entity pAttacker, int pLevel) {
        if (pUser instanceof Player && pAttacker instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)pAttacker;
            if (pUser.m_217043_().m_188501_() < this.getChance(pLevel)) {
                if (pAttacker instanceof Player) {
                    TeleportUtils.randomTeleport(attacker, this.getRange(pLevel));
                } else if ((double)pUser.m_217043_().m_188501_() < (Double)BaseConfig.COMMON.ENCHANTMENTS.REPELLENT_NON_PLAYER_CHANCE.get()) {
                    TeleportUtils.randomTeleport(attacker, this.getRange(pLevel));
                }
            }
        }
    }
}

