/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.integrations.jei.category;

import com.enderio.EnderIO;
import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.base.common.recipe.FireCraftingRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class FireCraftingCategory
implements IRecipeCategory<FireCraftingRecipe> {
    public static final RecipeType<FireCraftingRecipe> TYPE = RecipeType.create((String)"enderio", (String)"fire_crafting", FireCraftingRecipe.class);
    private static final ResourceLocation BG_LOCATION = EnderIO.loc("textures/gui/jei_infinity.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final ITickTimer timer;
    private final Map<ResourceLocation, Integer> blockIdx = new HashMap<ResourceLocation, Integer>();
    private int changed = 0;
    private boolean alternateFire = false;

    public FireCraftingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(BG_LOCATION, 0, 0, 109, 62);
        this.icon = guiHelper.createDrawable(BG_LOCATION, 109, 0, 16, 16);
        this.timer = guiHelper.createTickTimer(40, 1, false);
    }

    public RecipeType<FireCraftingRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return EIOLang.JEI_FIRE_CRAFTING_TITLE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public List<Component> getTooltipStrings(FireCraftingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 87.0 && mouseX <= 105.0 && mouseY >= 25.0 && mouseY <= 38.0) {
            List<ResourceLocation> validDimensions = recipe.getValidDimensions();
            ArrayList<Component> tooltip = new ArrayList<Component>(validDimensions.size() + 1);
            tooltip.add(EIOLang.JEI_FIRE_CRAFTING_VALID_DIMENSIONS);
            for (ResourceLocation dim : validDimensions) {
                tooltip.add((Component)Component.m_237113_((String)("- " + dim.toString())));
            }
            return tooltip;
        }
        if (mouseX >= 17.0 && mouseX <= 47.0 && mouseY >= 31.0 && mouseY <= 57.0) {
            List<Block> bases = recipe.getBases();
            ArrayList<Component> tooltip = new ArrayList<Component>(bases.size() + 1);
            tooltip.add(EIOLang.JEI_FIRE_CRAFTING_VALID_BLOCKS);
            for (Block block : bases) {
                tooltip.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)block.m_49954_()));
            }
            return tooltip;
        }
        return List.of();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FireCraftingRecipe recipe, IFocusGroup focuses) {
        IIngredientAcceptor block = builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST);
        block.addIngredients(Ingredient.m_43929_((ItemLike[])((ItemLike[])recipe.getBases().toArray(Block[]::new))));
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 88, 39).addTooltipCallback((slowView, tooltip) -> {
            MutableComponent lootTableComponent = MutableComponent.m_237204_((ComponentContents)EIOLang.JEI_FIRE_CRAFTING_LOOT_TABLE.m_214077_()).m_7220_((Component)Component.m_237113_((String)(" " + recipe.getLootTable())));
            MutableComponent maxDropsComponent = MutableComponent.m_237204_((ComponentContents)EIOLang.JEI_FIRE_CRAFTING_MAX_DROPS.m_214077_()).m_7220_((Component)Component.m_237113_((String)(" " + recipe.getMaxItemDrops())));
            tooltip.clear();
            tooltip.add(lootTableComponent);
            tooltip.add(maxDropsComponent);
        });
        output.addItemStack(EIOItems.GRAINS_OF_INFINITY.asStack());
        IRecipeSlotBuilder catalyst = builder.addSlot(RecipeIngredientRole.CATALYST, 88, 8).setSlotName("catalyst");
        catalyst.addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42409_, (ItemLike)EIOFluids.FIRE_WATER.getBucket().get()}));
    }

    public void draw(FireCraftingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (!Screen.m_96638_() && this.timer.getValue() != this.changed) {
            this.alternateFire = !this.alternateFire;
            this.changed = this.timer.getValue();
        }
        List<Block> blocks = recipe.getBases();
        Block block = blocks.get(0);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(31.0f, 31.0f, 100.0f);
        guiGraphics.m_280168_().m_85841_(20.0f, 20.0f, 20.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();
        guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        rotMat.rotation((Quaternionfc)Axis.f_252529_.m_252977_(30.0f));
        guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(-45.0f));
        rotMat.rotation((Quaternionfc)Axis.f_252436_.m_252977_(45.0f));
        eye.mul((Matrix4fc)rotMat);
        eye.div(eye.w);
        this.renderBlock(guiGraphics, block);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderBlock(GuiGraphics guiGraphics, Block block) {
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 0.0f);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        BlockState state = block.m_49966_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_(0.0, 0.5, 0.0);
        guiGraphics.m_280168_().m_85841_(1.0f, -1.0f, 1.0f);
        Minecraft.m_91087_().m_91289_().m_110912_(state, guiGraphics.m_280168_(), (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_);
        guiGraphics.m_280168_().m_85849_();
        BlockState fireState = !this.alternateFire ? Blocks.f_50083_.m_49966_() : EIOFluids.FIRE_WATER.getBlock().orElse(Blocks.f_50083_).m_49966_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_(0.0, -0.5, 0.0);
        guiGraphics.m_280168_().m_85841_(1.0f, -1.0f, 1.0f);
        Minecraft.m_91087_().m_91289_().renderSingleBlock(fireState, guiGraphics.m_280168_(), (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110463_());
        guiGraphics.m_280168_().m_85849_();
        buffers.m_109911_();
        guiGraphics.m_280168_().m_85849_();
    }
}

