/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.integrations.jei.extension;

import com.enderio.api.capability.StoredEntityData;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.integrations.jei.EnderIOJEI;
import com.enderio.base.common.recipe.ShapedEntityStorageRecipe;
import com.enderio.base.common.util.EntityCaptureUtils;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ShapedEntityStorageCategoryExtension
implements ICraftingCategoryExtension {
    protected final ShapedEntityStorageRecipe recipe;

    public ShapedEntityStorageCategoryExtension(ShapedEntityStorageRecipe recipe) {
        this.recipe = recipe;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        List<ResourceLocation> allCapturableEntities = EntityCaptureUtils.getCapturableEntities();
        ItemStack resultItem = EnderIOJEI.getResultItem(this.recipe);
        List<ItemStack> results = allCapturableEntities.stream().map(e -> {
            ItemStack result = resultItem.m_41777_();
            result.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(storage -> storage.setStoredEntityData(StoredEntityData.of(e)));
            return result;
        }).toList();
        List<List> inputs = this.recipe.m_7527_().stream().map(ingredient -> Arrays.stream(ingredient.m_43908_()).mapMulti((ingredientItem, consumer) -> {
            boolean hasStorage = ingredientItem.getCapability(EIOCapabilities.ENTITY_STORAGE).isPresent();
            if (hasStorage) {
                for (ResourceLocation entity : allCapturableEntities) {
                    ItemStack item = ingredientItem.m_41777_();
                    item.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(storage -> storage.setStoredEntityData(StoredEntityData.of(entity)));
                    consumer.accept(item);
                }
            } else {
                consumer.accept(ingredientItem);
            }
        }).toList()).toList();
        craftingGridHelper.createAndSetOutputs(builder, results);
        craftingGridHelper.createAndSetInputs(builder, inputs, this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        return this.recipe.m_44220_();
    }

    public int getHeight() {
        return this.recipe.m_44221_();
    }
}

