/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit;

import com.enderio.EnderIO;
import com.enderio.api.misc.Vector2i;
import com.enderio.base.common.util.ThrowableUtil;
import com.enderio.conduits.common.conduit.ConduitBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public class OffsetHelper {
    public static Map<Integer, Vector2i> positions = (Map)Util.m_137537_(() -> {
        HashMap<Integer, Vector2i> positions = new HashMap<Integer, Vector2i>();
        positions.put(1, new Vector2i(0, -1));
        positions.put(2, new Vector2i(-1, 0));
        positions.put(3, new Vector2i(0, 1));
        positions.put(4, new Vector2i(1, 0));
        positions.put(5, new Vector2i(1, -1));
        positions.put(6, new Vector2i(-1, -1));
        positions.put(7, new Vector2i(-1, 1));
        positions.put(8, new Vector2i(1, 1));
        positions.put(9, new Vector2i(0, 0));
        return positions;
    });

    public static Vector2i offsetConduit(int typeIndex, int maxTypes) {
        Vector2i vector2i;
        if (typeIndex >= maxTypes) {
            EnderIO.LOGGER.warn((Object)ThrowableUtil.addStackTrace(new IndexOutOfBoundsException("higher index than existing types")));
            return Vector2i.ZERO;
        }
        if (typeIndex < 0) {
            EnderIO.LOGGER.warn((Object)ThrowableUtil.addStackTrace(new IndexOutOfBoundsException("negative index")));
            return Vector2i.ZERO;
        }
        if (maxTypes == 1) {
            return Vector2i.ZERO;
        }
        if (maxTypes == 2) {
            return typeIndex == 0 ? new Vector2i(0, -1) : new Vector2i(0, 1);
        }
        if (maxTypes == 3) {
            switch (typeIndex) {
                case 0: {
                    return new Vector2i(-1, -1);
                }
                case 1: {
                    return Vector2i.ZERO;
                }
                case 2: {
                    return new Vector2i(1, 1);
                }
            }
            throw new IllegalStateException();
        }
        if (maxTypes < 9 && (vector2i = positions.get(typeIndex + 1)) != null) {
            return vector2i;
        }
        EnderIO.LOGGER.warn((Object)ThrowableUtil.addStackTrace(new IndexOutOfBoundsException("fallback was applied")));
        return Vector2i.ZERO;
    }

    public static Vec3i translationFor(Direction.Axis axis, Vector2i offset) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3i(0, offset.y(), offset.x());
            case Direction.Axis.Y -> new Vec3i(offset.x(), 0, offset.y());
            case Direction.Axis.Z -> new Vec3i(offset.x(), offset.y(), 0);
        };
    }

    public static Direction.Axis findMainAxis(ConduitBundle bundle) {
        ArrayList<Direction> connectedDirs = new ArrayList<Direction>();
        for (Direction dir : Direction.values()) {
            if (bundle.getConnectedTypes(dir).isEmpty()) continue;
            connectedDirs.add(dir);
        }
        if (connectedDirs.isEmpty()) {
            return Direction.Axis.Z;
        }
        return ((Direction)connectedDirs.get(connectedDirs.size() - 1)).m_122434_();
    }
}

