/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.fluid;

import com.enderio.api.conduit.ColoredRedstoneProvider;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitNode;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ticker.CapabilityAwareConduitTicker;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.FluidStackFilter;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.conduits.common.capability.ExtractionSpeedUpgrade;
import com.enderio.conduits.common.conduit.type.fluid.FluidConduitData;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidConduitTicker
extends CapabilityAwareConduitTicker<FluidConduitData, IFluidHandler> {
    private final boolean lockFluids;
    private final int baseFluidRate;

    public FluidConduitTicker(boolean lockFluids, int baseFluidRate) {
        this.lockFluids = lockFluids;
        this.baseFluidRate = baseFluidRate;
    }

    private int getScaledFluidRate(CapabilityAwareConduitTicker.CapabilityConnection extractingConnection) {
        int rate = (int)Math.ceil((double)this.baseFluidRate * (20.0 / (double)this.getTickRate()));
        ConduitUpgrade conduitUpgrade = extractingConnection.upgrade;
        if (conduitUpgrade instanceof ExtractionSpeedUpgrade) {
            ExtractionSpeedUpgrade speedUpgrade = (ExtractionSpeedUpgrade)conduitUpgrade;
            rate *= (int)Math.pow(2.0, speedUpgrade.tier());
        }
        return rate;
    }

    private int doFluidTransfer(FluidStack fluid, CapabilityAwareConduitTicker.CapabilityConnection extract, List<CapabilityAwareConduitTicker.CapabilityConnection> inserts) {
        FluidStackFilter fluidStackFilter;
        FluidStack extractedFluid = ((IFluidHandler)extract.capability).drain(fluid, IFluidHandler.FluidAction.SIMULATE);
        if (extractedFluid.isEmpty()) {
            return fluid.getAmount();
        }
        ResourceFilter resourceFilter = extract.extractFilter;
        if (resourceFilter instanceof FluidStackFilter && !(fluidStackFilter = (FluidStackFilter)resourceFilter).test(extractedFluid)) {
            return fluid.getAmount();
        }
        for (CapabilityAwareConduitTicker.CapabilityConnection insert : inserts) {
            FluidStackFilter fluidStackFilter2;
            ResourceFilter resourceFilter2 = insert.insertFilter;
            if (resourceFilter2 instanceof FluidStackFilter && !(fluidStackFilter2 = (FluidStackFilter)resourceFilter2).test(extractedFluid)) continue;
            FluidStack transferredFluid = FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)insert.capability), (IFluidHandler)((IFluidHandler)extract.capability), (FluidStack)fluid, (boolean)true);
            if (!transferredFluid.isEmpty()) {
                fluid.shrink(transferredFluid.getAmount());
            }
            if (fluid.getAmount() > 0) continue;
            break;
        }
        return fluid.getAmount();
    }

    @Override
    public void tickGraph(ServerLevel level, ConduitType<FluidConduitData> type, List<ConduitNode<FluidConduitData>> loadedNodes, ConduitGraph<FluidConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        boolean shouldReset = false;
        for (ConduitNode conduitNode : loadedNodes) {
            FluidConduitData fluidConduitData = ((FluidConduitData)conduitNode.getConduitData()).castTo(FluidConduitData.class);
            if (!fluidConduitData.shouldReset()) continue;
            shouldReset = true;
            fluidConduitData.setShouldReset(false);
        }
        if (shouldReset) {
            for (ConduitNode conduitNode : loadedNodes) {
                ((FluidConduitData)conduitNode.getConduitData()).setLockedFluid(null);
            }
        }
        super.tickGraph(level, type, loadedNodes, graph, coloredRedstoneProvider);
    }

    @Override
    protected void tickCapabilityGraph(ServerLevel level, ConduitType<FluidConduitData> type, List<CapabilityAwareConduitTicker.CapabilityConnection> inserts, List<CapabilityAwareConduitTicker.CapabilityConnection> extracts, ConduitGraph<FluidConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        block0: for (CapabilityAwareConduitTicker.CapabilityConnection extract : extracts) {
            IFluidHandler extractHandler = (IFluidHandler)extract.capability;
            FluidConduitData fluidConduitData = ((FluidConduitData)extract.data).castTo(FluidConduitData.class);
            int fluidRate = this.getScaledFluidRate(extract);
            if (fluidConduitData.lockedFluid() != null) {
                this.doFluidTransfer(new FluidStack(fluidConduitData.lockedFluid(), fluidRate), extract, inserts);
                continue;
            }
            int remaining = fluidRate;
            for (int i = 0; i < extractHandler.getTanks() && remaining > 0; ++i) {
                if (extractHandler.getFluidInTank(i).isEmpty()) continue;
                Fluid fluid = extractHandler.getFluidInTank(i).getFluid();
                remaining = this.doFluidTransfer(new FluidStack(fluid, remaining), extract, inserts);
                if (!this.lockFluids || remaining >= fluidRate) continue;
                for (ConduitNode<FluidConduitData> node : graph.getNodes()) {
                    if (fluid instanceof FlowingFluid) {
                        FlowingFluid flowing = (FlowingFluid)fluid;
                        fluid = flowing.m_5613_();
                    }
                    node.getConduitData().setLockedFluid(fluid);
                }
                continue block0;
            }
        }
    }

    @Override
    protected Capability<IFluidHandler> getCapability() {
        return ForgeCapabilities.FLUID_HANDLER;
    }
}

