/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.type.redstone;

import com.enderio.api.conduit.ConduitData;
import com.enderio.api.misc.ColorControl;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class RedstoneConduitData
implements ConduitData<RedstoneConduitData> {
    private boolean isActive = false;
    private final EnumMap<ColorControl, Integer> activeColors = new EnumMap(ColorControl.class);
    private static final String KEY_ACTIVE = "Active";
    private static final String KEY_COLORED_ACTIVE = "ColoredActive";
    private static final String KEY_ACTIVE_COLOR_MAP = "ActiveColors";

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_(KEY_ACTIVE, this.isActive);
        CompoundTag activeColorMap = new CompoundTag();
        for (Map.Entry<ColorControl, Integer> entry : this.activeColors.entrySet()) {
            activeColorMap.m_128365_(entry.getKey().name(), (Tag)IntTag.m_128679_((int)entry.getValue()));
        }
        nbt.m_128365_(KEY_ACTIVE_COLOR_MAP, (Tag)activeColorMap);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.isActive = nbt.m_128471_(KEY_ACTIVE);
        this.activeColors.clear();
        if (nbt.m_128425_(KEY_COLORED_ACTIVE, 9)) {
            ListTag list = nbt.m_128437_(KEY_COLORED_ACTIVE, 3);
            for (Tag tag : list) {
                IntTag intTag;
                int intValue;
                if (!(tag instanceof IntTag) || (intValue = (intTag = (IntTag)tag).m_7047_()) < 0 || intValue >= ColorControl.values().length) continue;
                ColorControl signalColor = ColorControl.values()[intValue];
                this.activeColors.put(signalColor, 15);
            }
        }
        if (nbt.m_128425_(KEY_ACTIVE_COLOR_MAP, 10)) {
            CompoundTag activeColorMap = nbt.m_128469_(KEY_ACTIVE_COLOR_MAP);
            for (ColorControl color : ColorControl.values()) {
                if (activeColorMap.m_128425_(color.name(), 3)) {
                    this.activeColors.put(color, activeColorMap.m_128451_(color.name()));
                    continue;
                }
                this.activeColors.put(color, 0);
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isActive(ColorControl color) {
        return this.activeColors.containsKey(color);
    }

    public int getSignal(ColorControl color) {
        return this.activeColors.getOrDefault(color, 0);
    }

    public void clearActive() {
        this.activeColors.clear();
        this.isActive = false;
    }

    public void setActiveColor(ColorControl color, int signal) {
        if (this.activeColors.containsKey(color)) {
            return;
        }
        this.isActive = true;
        this.activeColors.put(color, signal);
    }

    @Override
    public RedstoneConduitData deepCopy() {
        RedstoneConduitData redstoneConduitData = new RedstoneConduitData();
        redstoneConduitData.isActive = this.isActive;
        return redstoneConduitData;
    }

    public int hashCode() {
        return Objects.hash(this.isActive, this.activeColors);
    }
}

