/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.init;

import com.enderio.EnderIO;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.registry.EnderIORegistries;
import com.enderio.conduits.common.conduit.type.energy.EnergyConduitType;
import com.enderio.conduits.common.conduit.type.fluid.FluidConduitType;
import com.enderio.conduits.common.conduit.type.item.ItemConduitType;
import com.enderio.conduits.common.conduit.type.redstone.RedstoneConduitType;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class EIOConduitTypes {
    public static final DeferredRegister<ConduitType<?>> CONDUIT_TYPES = DeferredRegister.create(EnderIORegistries.Keys.CONDUIT_TYPES, (String)"enderio");
    public static final Supplier<IForgeRegistry<ConduitType<?>>> REGISTRY = CONDUIT_TYPES.makeRegistry(RegistryBuilder::new);
    public static final RegistryObject<EnergyConduitType> ENERGY = CONDUIT_TYPES.register("energy_conduit", EnergyConduitType::new);
    public static final RegistryObject<RedstoneConduitType> REDSTONE = CONDUIT_TYPES.register("redstone_conduit", RedstoneConduitType::new);
    public static final RegistryObject<FluidConduitType> FLUID = EIOConduitTypes.fluidConduit("fluid_conduit", 50, false);
    public static final RegistryObject<FluidConduitType> FLUID2 = EIOConduitTypes.fluidConduit("pressurized_fluid_conduit", 100, false);
    public static final RegistryObject<FluidConduitType> FLUID3 = EIOConduitTypes.fluidConduit("ender_fluid_conduit", 200, true);
    public static final RegistryObject<ItemConduitType> ITEM = CONDUIT_TYPES.register("item_conduit", ItemConduitType::new);

    public static int getConduitId(ConduitType<?> type) {
        return ((ForgeRegistry)REGISTRY.get()).getID(type);
    }

    public static ConduitType<?> getById(int id) {
        return (ConduitType)((ForgeRegistry)REGISTRY.get()).getValue(id);
    }

    private static RegistryObject<FluidConduitType> fluidConduit(String name, int tier, boolean isMultiFluid) {
        return CONDUIT_TYPES.register(name, () -> new FluidConduitType(EnderIO.loc(name), tier, isMultiFluid));
    }

    public static void register(IEventBus bus) {
        CONDUIT_TYPES.register(bus);
    }
}

