/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.capability;

import com.enderio.api.capability.StoredEntityData;
import com.enderio.api.filter.EntityFilter;
import com.enderio.core.common.capability.IFilterCapability;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;

public class EntityFilterCapability
implements IFilterCapability<StoredEntityData>,
EntityFilter {
    private static final String NBT_KEY = "IsNbt";
    private static final String INVERTED_KEY = "IsInverted";
    private static final String ENTRIES_KEY = "EntityEntries";
    private final ItemStack container;
    private final int size;

    public EntityFilterCapability(ItemStack container, int size) {
        this.container = container;
        this.size = size;
        CompoundTag tag = container.m_41784_();
        if (!tag.m_128425_(ENTRIES_KEY, 9)) {
            ListTag entriesList = new ListTag();
            for (int i = 0; i < size; ++i) {
                entriesList.add((Object)StoredEntityData.empty().serializeNBT());
            }
            tag.m_128365_(ENTRIES_KEY, (Tag)entriesList);
        }
    }

    @Override
    public void setNbt(Boolean nbt) {
        CompoundTag tag = this.container.m_41784_();
        tag.m_128379_(NBT_KEY, nbt.booleanValue());
    }

    @Override
    public boolean isNbt() {
        CompoundTag tag = this.container.m_41784_();
        return tag.m_128425_(NBT_KEY, 1) && tag.m_128471_(NBT_KEY);
    }

    @Override
    public void setInverted(Boolean inverted) {
        CompoundTag tag = this.container.m_41784_();
        tag.m_128379_(INVERTED_KEY, inverted.booleanValue());
    }

    @Override
    public boolean isInvert() {
        CompoundTag tag = this.container.m_41784_();
        return tag.m_128425_(INVERTED_KEY, 1) && tag.m_128471_(INVERTED_KEY);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<StoredEntityData> getEntries() {
        CompoundTag tag = this.container.m_41784_();
        ArrayList<StoredEntityData> entries = new ArrayList<StoredEntityData>();
        if (tag.m_128425_(ENTRIES_KEY, 9)) {
            ListTag entriesList = tag.m_128437_(ENTRIES_KEY, 10);
            for (Tag entry : entriesList) {
                StoredEntityData entityData = StoredEntityData.empty();
                entityData.deserializeNBT(entry);
                entries.add(entityData);
            }
        }
        return entries;
    }

    @Override
    public StoredEntityData getEntry(int index) {
        CompoundTag tag = this.container.m_41784_();
        if (!tag.m_128425_(ENTRIES_KEY, 9)) {
            return StoredEntityData.empty();
        }
        ListTag entriesList = tag.m_128437_(ENTRIES_KEY, 10);
        StoredEntityData entityData = StoredEntityData.empty();
        entityData.deserializeNBT(entriesList.get(index));
        return entityData;
    }

    @Override
    public void setEntry(int index, StoredEntityData entry) {
        ListTag entriesList;
        CompoundTag tag = this.container.m_41784_();
        if (tag.m_128425_(ENTRIES_KEY, 9)) {
            entriesList = tag.m_128437_(ENTRIES_KEY, 10);
        } else {
            entriesList = new ListTag();
            tag.m_128365_(ENTRIES_KEY, (Tag)entriesList);
        }
        entriesList.set(index, entry.serializeNBT());
    }

    @Override
    public boolean test(Entity entity) {
        boolean typematch = this.test(entity.m_6095_());
        if (this.isNbt()) {
            for (StoredEntityData entry : this.getEntries()) {
                CompoundTag tag = entity.serializeNBT();
                boolean test = tag.equals((Object)entry.getEntityTag());
                if (!test) continue;
                return !this.isInvert() && typematch;
            }
        }
        return typematch;
    }

    @Override
    public boolean test(EntityType<?> entity) {
        for (StoredEntityData entry : this.getEntries()) {
            ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_(entity);
            if (!entry.getEntityType().isPresent() || !entry.getEntityType().get().equals((Object)key)) continue;
            return !this.isInvert();
        }
        return this.isInvert();
    }
}

