/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client;

import com.enderio.base.common.handler.TravelHandler;
import net.minecraft.client.player.Input;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MachinesClientEvents {
    private static boolean LAST_JUMPING = false;
    private static boolean LAST_SNEAKING = false;
    private static int JUMP_COOLDOWN = 0;

    @SubscribeEvent
    public static void movementInputUpdate(MovementInputUpdateEvent event) {
        boolean success;
        Input input = event.getInput();
        Player player = event.getEntity();
        boolean isNewJump = input.f_108572_ && !LAST_JUMPING;
        LAST_JUMPING = input.f_108572_;
        boolean isNewCrouch = input.f_108573_ && !LAST_SNEAKING;
        LAST_SNEAKING = input.f_108573_;
        if (!player.m_20096_() || !TravelHandler.canBlockTeleport(player)) {
            JUMP_COOLDOWN = 0;
            return;
        }
        if (isNewJump) {
            boolean success2 = TravelHandler.blockElevatorTeleport(player.m_9236_(), player, Direction.UP, true);
            if (!success2) {
                success2 = TravelHandler.blockTeleport(player.m_9236_(), player, true);
            }
            JUMP_COOLDOWN = success2 ? 7 : 0;
        } else if (isNewCrouch && !(success = TravelHandler.blockElevatorTeleport(player.m_9236_(), player, Direction.DOWN, true))) {
            TravelHandler.blockTeleport(player.m_9236_(), player, true);
        }
        if (JUMP_COOLDOWN > 0) {
            --JUMP_COOLDOWN;
            input.f_108572_ = false;
        }
    }

    @SubscribeEvent
    public static void emptyClick(PlayerInteractEvent.RightClickEmpty event) {
        Player player = event.getEntity();
        if (TravelHandler.canBlockTeleport(player) && !player.m_6144_() && event.getHand() == InteractionHand.MAIN_HAND && event.getEntity().m_21120_(InteractionHand.OFF_HAND).m_41619_() && event.getItemStack().m_41619_() && TravelHandler.blockTeleport(event.getLevel(), event.getEntity(), true)) {
            player.m_21011_(event.getHand(), true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void blockClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!TravelHandler.canBlockTeleport(player)) {
            return;
        }
        if (TravelHandler.blockTeleport(event.getLevel(), event.getEntity(), true)) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void itemClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (!TravelHandler.canBlockTeleport(player)) {
            return;
        }
        if (TravelHandler.blockTeleport(event.getLevel(), event.getEntity(), true)) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

