/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.gui.widget.ioconfig;

import com.enderio.api.io.IOMode;
import com.enderio.base.common.lang.EIOLang;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;

public enum IOModeMap {
    NONE(IOMode.NONE, EIOLang.NONE, new Rect2i(0, 0, 0, 0)),
    PUSH(IOMode.PUSH, EIOLang.PUSH, new Rect2i(16, 16, 16, 8)),
    PULL(IOMode.PULL, EIOLang.PULL, new Rect2i(0, 16, 16, 8)),
    BOTH(IOMode.BOTH, EIOLang.BOTH, new Rect2i(0, 16, 32, 8)),
    DISABLED(IOMode.DISABLED, EIOLang.DISABLED, new Rect2i(32, 16, 16, 16));

    private static final IOModeMap[] BY_MODE;
    private final IOMode mode;
    private final Component component;
    private final Rect2i rect;

    public static IOModeMap getMapFromMode(IOMode mode) {
        return BY_MODE[mode.ordinal()];
    }

    private IOModeMap(IOMode mode, Component name, Rect2i rect) {
        this.mode = mode;
        this.component = name;
        this.rect = rect;
    }

    public IOMode getMode() {
        return this.mode;
    }

    public Component getComponent() {
        return this.component;
    }

    public Rect2i getRect() {
        return this.rect;
    }

    static {
        BY_MODE = (IOModeMap[])Arrays.stream(IOModeMap.values()).sorted(Comparator.comparingInt(m -> m.mode.ordinal())).toArray(IOModeMap[]::new);
    }
}

