/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.recipe.SlicingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class SlicerRecipeManager {
    private static final List<Set<Item>> ITEMS = (List)Util.m_137537_(() -> {
        ArrayList tempList = new ArrayList();
        for (int i = 0; i < 6; ++i) {
            tempList.add(new HashSet());
        }
        return tempList;
    });
    private static final List<Set<Ingredient>> NON_OPTIMIZABLE_INGREDIENTS = (List)Util.m_137537_(() -> {
        ArrayList tempList = new ArrayList();
        for (int i = 0; i < 6; ++i) {
            tempList.add(new HashSet());
        }
        return tempList;
    });
    private static boolean clearCache = false;

    public static boolean isSlicerValid(ItemStack stack, int slot) {
        SlicerRecipeManager.checkCacheRebuild();
        if (ITEMS.get(slot).contains(stack.m_41720_())) {
            return true;
        }
        for (Ingredient ingredient : NON_OPTIMIZABLE_INGREDIENTS.get(slot)) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void registerReloadListener(AddReloadListenerEvent event) {
        clearCache = true;
    }

    @SubscribeEvent
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        SlicerRecipeManager.rebuildCache(event.getRecipeManager());
    }

    private static void checkCacheRebuild() {
        if (clearCache && EffectiveSide.get().isServer()) {
            SlicerRecipeManager.rebuildCache(ServerLifecycleHooks.getCurrentServer().m_129894_());
            clearCache = false;
        }
    }

    private static void rebuildCache(RecipeManager manager) {
        for (Set<Item> set : ITEMS) {
            set.clear();
        }
        for (Set<Item> set : NON_OPTIMIZABLE_INGREDIENTS) {
            set.clear();
        }
        for (SlicingRecipe slicingRecipe : manager.m_44013_((RecipeType)MachineRecipes.SLICING.type().get())) {
            for (int i = 0; i < 6; ++i) {
                Ingredient ingredient = slicingRecipe.getInputs().get(i);
                if (ingredient.isSimple()) {
                    Set<Item> itemset = ITEMS.get(i);
                    Arrays.stream(ingredient.m_43908_()).map(ItemStack::m_41720_).forEach(itemset::add);
                    continue;
                }
                NON_OPTIMIZABLE_INGREDIENTS.get(i).add(ingredient);
            }
        }
    }
}

