/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.base;

import com.enderio.api.io.IIOConfig;
import com.enderio.api.io.IOMode;
import com.enderio.base.common.util.AttractionUtil;
import com.enderio.core.common.network.slot.BooleanNetworkDataSlot;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.io.FixedIOConfig;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class VacuumMachineBlockEntity<T extends Entity>
extends MachineBlockEntity {
    private static final double COLLISION_DISTANCE_SQ = 1.0;
    protected static final double SPEED = 0.025;
    protected static final double SPEED_4 = 0.1;
    private List<WeakReference<T>> entities = new ArrayList<WeakReference<T>>();
    private Class<T> targetClass;
    protected static final Predicate<ItemEntity> ITEM_ENTITY_FILTER_TRUE = itemEntity -> true;

    public VacuumMachineBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState, Class<T> targetClass) {
        super(pType, pWorldPosition, pBlockState);
        this.targetClass = targetClass;
        this.rangeDataSlot = new IntegerNetworkDataSlot(this::getRange, r -> {
            this.range = r;
        });
        this.addDataSlot(this.rangeDataSlot);
        this.rangeVisibleDataSlot = new BooleanNetworkDataSlot(this::isRangeVisible, b -> {
            this.rangeVisible = b;
        });
        this.addDataSlot(this.rangeVisibleDataSlot);
    }

    @Override
    public void serverTick() {
        if (!this.isRedstoneBlocked()) {
            this.attractEntities(this.m_58904_(), this.m_58899_(), this.getRange());
        }
        super.serverTick();
    }

    @Override
    public void clientTick() {
        if (!this.isRedstoneBlocked()) {
            this.attractEntities(this.m_58904_(), this.m_58899_(), this.getRange());
        }
        super.clientTick();
    }

    @Override
    protected IIOConfig createIOConfig() {
        return new FixedIOConfig(IOMode.PUSH);
    }

    public Predicate<T> getFilter() {
        return e -> true;
    }

    private void attractEntities(Level level, BlockPos pos, int range) {
        if ((level.m_46467_() + pos.m_121878_()) % 5L == 0L) {
            this.getEntities(level, pos, range, this.getFilter());
        }
        Iterator<WeakReference<T>> iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            WeakReference<T> ref = iterator.next();
            if (ref.get() == null) {
                iterator.remove();
                continue;
            }
            Entity entity = (Entity)ref.get();
            if (entity.m_213877_()) {
                iterator.remove();
                continue;
            }
            if (!AttractionUtil.moveToPos(entity, pos, 0.025, 0.1, 1.0)) continue;
            this.handleEntity(entity);
        }
    }

    public abstract void handleEntity(T var1);

    private void getEntities(Level level, BlockPos pos, int range, Predicate<T> filter) {
        this.entities.clear();
        AABB area = new AABB(pos).m_82400_((double)range);
        for (Entity ie : level.m_6443_(this.targetClass, area, filter)) {
            this.entities.add(new WeakReference<Entity>(ie));
        }
    }

    @Override
    public int getMaxRange() {
        return 6;
    }

    @Override
    public void onLoad() {
        if (this.entities.isEmpty()) {
            this.getEntities(this.m_58904_(), this.m_58899_(), this.getRange(), this.getFilter());
        }
        super.onLoad();
    }
}

