/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.sync;

import com.enderio.core.common.network.slot.NetworkDataSlot;
import com.enderio.machines.common.io.energy.ILargeMachineEnergyStorage;
import com.enderio.machines.common.io.energy.LargeImmutableMachineEnergyStorage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class LargeMachineEnergyDataSlot
extends NetworkDataSlot<ILargeMachineEnergyStorage> {
    public LargeMachineEnergyDataSlot(Supplier<ILargeMachineEnergyStorage> getter, Consumer<ILargeMachineEnergyStorage> setter) {
        super(getter, setter);
    }

    @Override
    public Tag serializeValueNBT(ILargeMachineEnergyStorage value) {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("EnergyStored", value.getLargeEnergyStored());
        tag.m_128356_("MaxEnergyStored", value.getLargeMaxEnergyStored());
        return tag;
    }

    @Override
    protected ILargeMachineEnergyStorage valueFromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)nbt;
            long energy = compoundTag.m_128454_("EnergyStored");
            long maxStored = compoundTag.m_128454_("MaxEnergyStored");
            return new LargeImmutableMachineEnergyStorage(energy, maxStored);
        }
        throw new IllegalStateException("Invalid LargeMachineEnergy was passed over the network.");
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, ILargeMachineEnergyStorage value) {
        buf.writeLong(value.getLargeEnergyStored());
        buf.writeLong(value.getLargeMaxEnergyStored());
    }

    @Override
    public ILargeMachineEnergyStorage valueFromBuffer(FriendlyByteBuf buf) {
        try {
            long energy = buf.readLong();
            long maxStored = buf.readLong();
            return new LargeImmutableMachineEnergyStorage(energy, maxStored);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid LargeMachineEnergy buffer was passed over the network.");
        }
    }

    @Override
    protected int hashCode(ILargeMachineEnergyStorage value) {
        int code = 1;
        code = 31 * code + Long.hashCode(value.getLargeEnergyStored());
        code = 31 * code + Long.hashCode(value.getLargeMaxEnergyStored());
        return code;
    }
}

