/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.jei;

import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.integrations.jei.util.WrappedEnchanterRecipe;
import com.enderio.machines.common.recipe.AlloySmeltingRecipe;
import com.enderio.machines.common.recipe.EnchanterRecipe;
import com.enderio.machines.common.recipe.SagMillingRecipe;
import com.enderio.machines.common.recipe.SlicingRecipe;
import com.enderio.machines.common.recipe.SoulBindingRecipe;
import com.enderio.machines.common.recipe.TankRecipe;
import com.enderio.machines.common.souldata.EngineSoul;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class MachineJEIRecipes {
    private final RecipeManager recipeManager;

    public MachineJEIRecipes() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        this.recipeManager = Objects.requireNonNull(level).m_7465_();
    }

    public List<AlloySmeltingRecipe> getAlloySmeltingRecipes() {
        return this.recipeManager.m_44013_((RecipeType)MachineRecipes.ALLOY_SMELTING.type().get()).stream().filter(recipe -> !recipe.isSmelting()).toList();
    }

    public List<AlloySmeltingRecipe> getAlloySmeltingRecipesWithSmelting() {
        return this.recipeManager.m_44013_((RecipeType)MachineRecipes.ALLOY_SMELTING.type().get());
    }

    public List<SlicingRecipe> getSlicingRecipes() {
        return this.recipeManager.m_44013_((RecipeType)MachineRecipes.SLICING.type().get());
    }

    public List<SoulBindingRecipe> getSoulBindingRecipes() {
        return this.recipeManager.m_44013_((RecipeType)MachineRecipes.SOUL_BINDING.type().get());
    }

    public List<TankRecipe> getTankRecipes() {
        return this.recipeManager.m_44013_((RecipeType)MachineRecipes.TANK.type().get());
    }

    public List<WrappedEnchanterRecipe> getEnchanterRecipes() {
        return this.recipeManager.m_44013_((RecipeType)MachineRecipes.ENCHANTING.type().get()).stream().mapMulti((recipe, consumer) -> {
            for (int i = 1; i <= recipe.getEnchantment().m_6586_(); ++i) {
                consumer.accept(new WrappedEnchanterRecipe((EnchanterRecipe)recipe, i));
            }
        }).toList();
    }

    public List<SagMillingRecipe> getSagMillingRecipes() {
        return this.recipeManager.m_44013_((RecipeType)MachineRecipes.SAG_MILLING.type().get());
    }

    public List<EngineSoul.SoulData> getMobGeneratorRecipes() {
        return EngineSoul.ENGINE.map.values().stream().toList();
    }
}

