/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.fluid;

import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.io.fluid.TankAccess;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public interface IFluidItemInteractive {
    default public boolean handleFluidItemInteraction(Player player, InteractionHand hand, ItemStack itemStack, MachineBlockEntity machine, TankAccess tankAccess) {
        ItemStack copyStack = itemStack.m_255036_(1);
        Optional fluidHandlerItem = FluidUtil.getFluidHandler((ItemStack)copyStack).resolve();
        if (fluidHandlerItem.isPresent()) {
            IFluidHandlerItem handler = (IFluidHandlerItem)fluidHandlerItem.get();
            FluidStack fluidInItem = tankAccess.isEmpty(machine) ? handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE) : handler.drain(new FluidStack(tankAccess.getFluid(machine), Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
            if (fluidInItem.isEmpty()) {
                if (!tankAccess.isEmpty(machine)) {
                    int filled = handler.fill(tankAccess.getFluid(machine), player.m_7500_() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                    ItemStack container = handler.getContainer();
                    if (filled > 0) {
                        if (itemStack.m_41613_() == 1) {
                            player.m_21008_(hand, container);
                        } else if (itemStack.m_41613_() > 1 && player.m_150109_().m_36054_(container)) {
                            itemStack.m_41774_(1);
                        } else {
                            player.m_7197_(container, false, true);
                            itemStack.m_41774_(1);
                        }
                        tankAccess.drain(machine, filled, IFluidHandler.FluidAction.EXECUTE);
                        return true;
                    }
                }
            } else {
                int filledAmount = tankAccess.fill(machine, fluidInItem, IFluidHandler.FluidAction.SIMULATE);
                if (filledAmount > 0) {
                    boolean filled = false;
                    FluidStack fluidToFill = handler.drain(new FluidStack(fluidInItem, filledAmount), player.m_7500_() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                    if (!fluidToFill.isEmpty()) {
                        ItemStack container = handler.getContainer();
                        if (player.m_7500_()) {
                            filled = true;
                        } else if (!container.m_41619_()) {
                            if (itemStack.m_41613_() == 1) {
                                player.m_21008_(hand, container);
                                filled = true;
                            } else if (player.m_150109_().m_36054_(container)) {
                                itemStack.m_41774_(1);
                                filled = true;
                            }
                        } else {
                            itemStack.m_41774_(1);
                            if (itemStack.m_41619_()) {
                                player.m_21008_(hand, ItemStack.f_41583_);
                            }
                            filled = true;
                        }
                        if (filled) {
                            tankAccess.fill(machine, fluidToFill, IFluidHandler.FluidAction.EXECUTE);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

