/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.fluid;

import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class MachineFluidTank
implements IFluidTank {
    public static final String Capacity = "Capacity";
    private final int capacity;
    @NotNull
    private FluidStack fluid = FluidStack.EMPTY;
    public static final MachineFluidTank EMPTY = new MachineFluidTank(0);

    public MachineFluidTank(int capacity) {
        this.capacity = capacity;
    }

    public MachineFluidTank(FluidStack stack, int capacity) {
        this(capacity);
        this.fluid = stack.copy();
    }

    public static MachineFluidTank from(CompoundTag tag) {
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)tag);
        int capacity = tag.m_128451_(Capacity);
        return new MachineFluidTank(stack, capacity);
    }

    public int getCapacity() {
        return this.capacity;
    }

    @NotNull
    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public int getFluidAmount() {
        return this.fluid.getAmount();
    }

    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    public boolean isEmpty() {
        return this.getFluid().isEmpty();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        if (action.simulate()) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.fluid = new FluidStack(resource, Math.min(this.capacity, resource.getAmount()));
            this.onContentsChanged();
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
        }
        if (filled > 0) {
            this.onContentsChanged();
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action.execute() && drained > 0) {
            this.fluid.shrink(drained);
            this.onContentsChanged();
        }
        return stack;
    }

    protected void onContentsChanged() {
    }

    public CompoundTag save(CompoundTag compoundTag) {
        this.getFluid().writeToNBT(compoundTag);
        compoundTag.m_128405_(Capacity, this.getCapacity());
        return compoundTag;
    }
}

