/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.gui;

import dev.dediamondpro.resourcify.libs.elementa.ElementaVersion;
import dev.dediamondpro.resourcify.libs.elementa.WindowScreen;
import dev.dediamondpro.resourcify.libs.universal.UKeyboard;
import dev.dediamondpro.resourcify.libs.universal.UMinecraft;
import dev.dediamondpro.resourcify.libs.universal.UResolution;
import dev.dediamondpro.resourcify.libs.universal.UScreen;
import dev.dediamondpro.resourcify.util.NetworkUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 !2\u00020\u0001:\u0001!B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0017\u0010\bJ\u000f\u0010\u0018\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0018\u0010\bJ\u001b\u0010\u001c\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Ldev/dediamondpro/resourcify/gui/PaginatedScreen;", "Ldev/dediamondpro/resourcify/libs/elementa/WindowScreen;", "", "adaptScale", "<init>", "(Z)V", "", "onTick", "()V", "", "keyCode", "", "typedChar", "Ldev/dediamondpro/resourcify/libs/universal/UKeyboard$Modifiers;", "modifiers", "onKeyPressed", "(ICLdev/dediamondpro/resourcify/libs/universal/UKeyboard$Modifiers;)V", "", "mouseX", "mouseY", "mouseButton", "onMouseClicked", "(DDI)V", "goBack", "goForward", "Lkotlin/Function0;", "Lnet/minecraft/client/gui/screens/Screen;", "screen", "replaceScreen", "(Lkotlin/jvm/functions/Function0;)V", "Z", "defaultScale", "I", "Companion", "Resourcify (1.20.1-forge)-1.7.0"})
@SourceDebugExtension(value={"SMAP\nPaginatedScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaginatedScreen.kt\ndev/dediamondpro/resourcify/gui/PaginatedScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public abstract class PaginatedScreen
extends WindowScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean adaptScale;
    private int defaultScale;
    private static boolean replacingScreen;
    @NotNull
    private static final List<Screen> backScreens;
    @NotNull
    private static final List<Screen> forwardScreens;

    public PaginatedScreen(boolean adaptScale) {
        super(ElementaVersion.V5, false, true, false, 0, 26, null);
        this.adaptScale = adaptScale;
        this.defaultScale = -1;
        if (!replacingScreen) {
            Screen screen = UScreen.Companion.getCurrentScreen();
            if (screen != null) {
                Screen it = screen;
                boolean bl = false;
                backScreens.add(it);
            }
            forwardScreens.clear();
        }
    }

    public /* synthetic */ PaginatedScreen(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @Override
    public void onTick() {
        int updatedScale;
        if (!this.adaptScale) {
            return;
        }
        if (this.defaultScale == -1) {
            this.defaultScale = UMinecraft.getGuiScale();
        }
        if ((updatedScale = PaginatedScreen.Companion.getGuiScale(this.defaultScale)) != (int)UResolution.getScaleFactor()) {
            this.setNewGuiScale(updatedScale);
            this.updateGuiScale();
            UMinecraft.setGuiScale(updatedScale);
            Intrinsics.checkNotNull((Object)((Object)this), (String)"null cannot be cast to non-null type net.minecraft.client.gui.screens.Screen");
            ((Screen)this).f_96543_ = UResolution.getScaledWidth();
            ((Screen)this).f_96544_ = UResolution.getScaledHeight();
        }
        super.onTick();
    }

    @Override
    public void onKeyPressed(int keyCode, char typedChar, @Nullable UKeyboard.Modifiers modifiers) {
        if (this.getWindow().getFocusedComponent() == null && keyCode == UKeyboard.KEY_ESCAPE) {
            this.goBack();
        } else {
            super.onKeyPressed(keyCode, typedChar, modifiers);
        }
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        switch (mouseButton) {
            case 3: {
                this.goBack();
                break;
            }
            case 4: {
                this.goForward();
                break;
            }
            default: {
                super.onMouseClicked(mouseX, mouseY, mouseButton);
            }
        }
    }

    public void goBack() {
        Screen backScreen = (Screen)CollectionsKt.removeLastOrNull(backScreens);
        if (backScreen instanceof PaginatedScreen) {
            forwardScreens.add(this);
        } else {
            Companion.cleanUp();
        }
        UScreen.Companion.displayScreen(backScreen);
    }

    public void goForward() {
        Screen screen = (Screen)CollectionsKt.removeLastOrNull(forwardScreens);
        if (screen == null) {
            return;
        }
        Screen forwardScreen = screen;
        backScreens.add(this);
        UScreen.Companion.displayScreen(forwardScreen);
    }

    public final void replaceScreen(@NotNull Function0<? extends Screen> screen) {
        Intrinsics.checkNotNullParameter(screen, (String)"screen");
        replacingScreen = true;
        UScreen.Companion.displayScreen((Screen)screen.invoke());
        replacingScreen = false;
    }

    public PaginatedScreen() {
        this(false, 1, (DefaultConstructorMarker)null);
    }

    static {
        backScreens = new ArrayList();
        forwardScreens = new ArrayList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\tR\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0017"}, d2={"Ldev/dediamondpro/resourcify/gui/PaginatedScreen$Companion;", "", "<init>", "()V", "", "cleanUp", "", "defaultScale", "getGuiScale", "(I)I", "guiScale", "calculateScaleFactor", "", "replacingScreen", "Z", "", "Lnet/minecraft/client/gui/screens/Screen;", "backScreens", "Ljava/util/List;", "getBackScreens", "()Ljava/util/List;", "forwardScreens", "getForwardScreens", "Resourcify (1.20.1-forge)-1.7.0"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Screen> getBackScreens() {
            return backScreens;
        }

        @NotNull
        public final List<Screen> getForwardScreens() {
            return forwardScreens;
        }

        public final void cleanUp() {
            this.getBackScreens().clear();
            this.getForwardScreens().clear();
            NetworkUtil.INSTANCE.clearCache();
        }

        private final int getGuiScale(int defaultScale) {
            int minScale = (int)Math.floor((float)UResolution.getWindowWidth() / 692.0f);
            return RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)minScale, (int)1), (int)this.calculateScaleFactor(defaultScale));
        }

        private final int calculateScaleFactor(int guiScale) {
            Minecraft mc = UMinecraft.getMinecraft();
            return mc.m_91268_().m_85385_(guiScale, mc.m_91390_());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

