/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark;

import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import dev.dediamondpro.resourcify.libs.minemark.utils.StyleType;
import java.awt.Color;
import java.util.HashMap;

public class LayoutStyle {
    private Alignment alignment;
    private float fontSize;
    private Color textColor;
    private boolean bold;
    private boolean italic;
    private boolean underlined;
    private boolean strikethrough;
    private boolean partOfLink;
    private boolean partOfCodeBlock;
    private boolean preFormatted;
    private final HashMap<StyleType<?>, Object> customStyles;

    public LayoutStyle(Alignment alignment, float fontSize, Color textColor, boolean bold, boolean italic, boolean underlined, boolean strikethrough, boolean partOfLink, boolean partOfCodeBlock, boolean preFormatted, HashMap<StyleType<?>, Object> customStyles) {
        this.alignment = alignment;
        this.fontSize = fontSize;
        this.textColor = textColor;
        this.bold = bold;
        this.italic = italic;
        this.underlined = underlined;
        this.partOfLink = partOfLink;
        this.preFormatted = preFormatted;
        this.partOfCodeBlock = partOfCodeBlock;
        this.strikethrough = strikethrough;
        this.customStyles = customStyles;
    }

    public LayoutStyle(Style style) {
        this(Alignment.LEFT, style.getTextStyle().getDefaultFontSize(), style.getTextStyle().getDefaultTextColor(), false, false, false, false, false, false, false, new HashMap());
    }

    public LayoutStyle clone() {
        return new LayoutStyle(this.alignment, this.fontSize, new Color(this.textColor.getRGB()), this.bold, this.italic, this.underlined, this.strikethrough, this.partOfLink, this.partOfCodeBlock, this.preFormatted, (HashMap)this.customStyles.clone());
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public void setStrikethrough(boolean strikethrough) {
        this.strikethrough = strikethrough;
    }

    public boolean isPartOfLink() {
        return this.partOfLink;
    }

    public void setPartOfLink(boolean partOfLink) {
        this.partOfLink = partOfLink;
    }

    public boolean isPreFormatted() {
        return this.preFormatted;
    }

    public void setPreFormatted(boolean preFormatted) {
        this.preFormatted = preFormatted;
    }

    public boolean isPartOfCodeBlock() {
        return this.partOfCodeBlock;
    }

    public void setPartOfCodeBlock(boolean partOfCodeBlock) {
        this.partOfCodeBlock = partOfCodeBlock;
    }

    public <T> void put(StyleType<T> styleType, T value) {
        this.customStyles.put(styleType, value);
    }

    public <T> void remove(StyleType<T> styleType) {
        this.customStyles.remove(styleType);
    }

    public <T> boolean has(StyleType<T> styleType) {
        return this.customStyles.containsKey(styleType);
    }

    public <T> T get(StyleType<T> styleType) {
        return styleType.getStyleClass().cast(this.customStyles.get(styleType));
    }

    public <T> T getOrDefault(StyleType<T> styleType, T defaultValue) {
        return styleType.getStyleClass().cast(this.customStyles.getOrDefault(styleType, defaultValue));
    }

    public static enum Alignment {
        CENTER,
        LEFT,
        RIGHT;

    }
}

