/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements.impl;

import dev.dediamondpro.resourcify.libs.minemark.LayoutData;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.ChildBasedElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.elements.Inline;
import dev.dediamondpro.resourcify.libs.minemark.style.HeadingLevelStyleConfig;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import java.awt.Color;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class HeadingElement<S extends Style, R>
extends ChildBasedElement<S, R>
implements Inline {
    protected final HeadingType headingType;
    protected final HeadingLevelStyleConfig headingStyle;
    protected LayoutData.MarkDownElementPosition dividerPosition;

    public HeadingElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes) {
        super(style, layoutStyle, parent, qName, attributes);
        this.headingType = HeadingType.getFromHtmlTag(qName);
        this.headingStyle = this.headingType.getHeadingStyle((Style)style);
        this.layoutStyle = this.layoutStyle.clone();
        this.layoutStyle.setFontSize(this.headingStyle.getFontSize());
    }

    @Override
    public void drawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        super.drawInternal(xOffset, yOffset, mouseX, mouseY, renderData);
        if (this.headingStyle.hasDivider()) {
            this.drawDivider(xOffset + this.dividerPosition.getX(), yOffset + this.dividerPosition.getY(), this.dividerPosition.getWidth(), this.dividerPosition.getHeight(), this.headingStyle.getDividerColor(), renderData);
        }
    }

    @Override
    @ApiStatus.Internal
    public void generateLayout(LayoutData layoutData, R renderData) {
        if (layoutData.isLineOccupied()) {
            layoutData.nextLine();
        }
        super.generateLayout(layoutData, renderData);
        if (this.headingStyle.hasDivider()) {
            layoutData.setBottomSpacing(this.headingStyle.getSpaceBeforeDivider());
            layoutData.nextLine();
            this.dividerPosition = layoutData.addElement(this.layoutStyle.getAlignment(), layoutData.getMaxWidth(), this.headingStyle.getDividerHeight());
            layoutData.setBottomSpacing(this.headingStyle.getPadding());
        }
        layoutData.nextLine();
    }

    @Override
    protected float getPadding(LayoutData layoutData, R renderData) {
        return this.headingStyle.getPadding();
    }

    protected abstract void drawDivider(float var1, float var2, float var3, float var4, Color var5, R var6);

    public String toString() {
        return "HeadingElement {" + (Object)((Object)this.headingType) + "}";
    }

    public static enum HeadingType {
        H1,
        H2,
        H3,
        H4,
        H5,
        H6;


        public HeadingLevelStyleConfig getHeadingStyle(Style style) {
            switch (this) {
                case H1: {
                    return style.getHeadingStyle().getH1();
                }
                case H2: {
                    return style.getHeadingStyle().getH2();
                }
                case H3: {
                    return style.getHeadingStyle().getH3();
                }
                case H4: {
                    return style.getHeadingStyle().getH4();
                }
                case H5: {
                    return style.getHeadingStyle().getH5();
                }
                case H6: {
                    return style.getHeadingStyle().getH6();
                }
            }
            throw new IllegalStateException("This should literally never be thrown.");
        }

        public static HeadingType getFromHtmlTag(String tag) {
            for (HeadingType type2 : HeadingType.values()) {
                if (!tag.equals(type2.name().toLowerCase())) continue;
                return type2;
            }
            throw new IllegalStateException("Unknown heading tag  \" " + tag + "\"");
        }
    }
}

