/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.platform;

import com.google.common.collect.Lists;
import dev.dediamondpro.resourcify.libs.universal.UMinecraft;
import dev.dediamondpro.resourcify.mixins.AbstractResourcePackAccessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u000f\u00a2\u0006\u0004\b \u0010\u0003\u00a8\u0006!"}, d2={"Ldev/dediamondpro/resourcify/platform/Platform;", "", "<init>", "()V", "", "getMcVersion", "()Ljava/lang/String;", "Lnet/minecraft/client/gui/screens/Screen;", "screen", "getTranslateKey", "(Lnet/minecraft/client/gui/screens/Screen;)Ljava/lang/String;", "", "Ljava/io/File;", "getSelectedResourcePacks", "()Ljava/util/List;", "", "reloadResources", "file", "", "closeResourcePack", "(Ljava/io/File;)I", "position", "enableResourcePack", "(Ljava/io/File;I)V", "Lnet/minecraft/server/packs/repository/PackRepository;", "arg", "applyResources", "(Lnet/minecraft/server/packs/repository/PackRepository;)V", "Lnet/minecraft/server/packs/FilePackResources;", "resourcePack", "getResourcePackFile", "(Lnet/minecraft/server/packs/FilePackResources;)Ljava/io/File;", "saveSettings", "Resourcify (1.20.1-forge)-1.7.0"})
@SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\ndev/dediamondpro/resourcify/platform/Platform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1611#2,9:126\n1863#2:135\n1864#2:137\n1620#2:138\n295#2,2:139\n1557#2:141\n1628#2,3:142\n295#2,2:145\n1557#2:147\n1628#2,3:148\n1#3:136\n*S KotlinDebug\n*F\n+ 1 Platform.kt\ndev/dediamondpro/resourcify/platform/Platform\n*L\n50#1:126,9\n50#1:135\n50#1:137\n50#1:138\n66#1:139,2\n76#1:141\n76#1:142,3\n89#1:145,2\n95#1:147\n95#1:148,3\n50#1:136\n*E\n"})
public final class Platform {
    @NotNull
    public static final Platform INSTANCE = new Platform();

    private Platform() {
    }

    @NotNull
    public final String getMcVersion() {
        String string = SharedConstants.m_183709_().m_132493_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public final String getTranslateKey(@NotNull Screen screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        ComponentContents content = screen.m_96636_().m_214077_();
        if (!(content instanceof TranslatableContents)) {
            String optifineTranslation = I18n.m_118938_((String)"of.options.shadersTitle", (Object[])new Object[0]);
            if (!Intrinsics.areEqual((Object)optifineTranslation, (Object)"of.options.shadersTitle") && Intrinsics.areEqual((Object)optifineTranslation, (Object)screen.m_96636_().getString())) {
                return "of.options.shadersTitle";
            }
            String string = screen.m_96636_().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return string;
        }
        String string = ((TranslatableContents)content).m_237508_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getSelectedResourcePacks() {
        void $this$mapNotNullTo$iv$iv;
        Collection collection = UMinecraft.getMinecraft().m_91099_().m_10524_();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSelectedPacks(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pack it = (Pack)element$iv$iv;
            boolean bl2 = false;
            PackResources pack = it.m_10445_();
            File result = pack instanceof FilePackResources ? INSTANCE.getResourcePackFile((FilePackResources)pack) : null;
            pack.close();
            if (result == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void reloadResources() {
        UMinecraft.getMinecraft().m_91391_();
    }

    /*
     * WARNING - void declaration
     */
    public final int closeResourcePack(@NotNull File file) {
        Object v1;
        ArrayList packs;
        PackRepository repo;
        block4: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            repo = UMinecraft.getMinecraft().m_91099_();
            repo.m_10506_();
            packs = Lists.newArrayList((Iterable)repo.m_10524_());
            Collection collection = repo.m_10519_();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAvailablePacks(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pack it = (Pack)element$iv;
                boolean bl = false;
                PackResources pack = it.m_10445_();
                boolean result = pack instanceof FilePackResources && Intrinsics.areEqual((Object)INSTANCE.getResourcePackFile((FilePackResources)pack), (Object)file);
                pack.close();
                if (!result) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        Pack pack = v1;
        if (pack != null) {
            int index = packs.indexOf(pack);
            if (index != -1) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object element$iv;
                packs.remove(pack);
                Intrinsics.checkNotNull((Object)packs);
                Iterable $i$f$firstOrNull = packs;
                PackRepository packRepository = repo;
                boolean $i$f$map = false;
                element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pack pack2 = (Pack)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.m_10446_());
                }
                packRepository.m_10509_((Collection)((List)destination$iv$iv));
                Intrinsics.checkNotNull((Object)repo);
                this.applyResources(repo);
            }
            return index;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void enableResourcePack(@NotNull File file, int position) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object v1;
        PackResources pack;
        ArrayList arrayList;
        int n;
        ArrayList packs;
        PackRepository repo;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            repo = UMinecraft.getMinecraft().m_91099_();
            repo.m_10506_();
            packs = Lists.newArrayList((Iterable)repo.m_10524_());
            Collection collection = repo.m_10519_();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAvailablePacks(...)");
            Iterable iterable = collection;
            n = position;
            arrayList = packs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pack it = (Pack)element$iv;
                boolean bl = false;
                pack = it.m_10445_();
                boolean result = pack instanceof FilePackResources && Intrinsics.areEqual((Object)INSTANCE.getResourcePackFile((FilePackResources)pack), (Object)file);
                pack.close();
                if (!result) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Object var16_20 = v1;
        Pack pack2 = var16_20;
        if (pack2 == null) {
            return;
        }
        arrayList.add(n, pack2);
        Intrinsics.checkNotNull((Object)packs);
        Iterable iterable = packs;
        arrayList = repo;
        boolean $i$f$map = false;
        void $i$f$firstOrNull = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            pack = (Pack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.m_10446_());
        }
        arrayList.m_10509_((List)destination$iv$iv);
        Intrinsics.checkNotNull((Object)repo);
        this.applyResources(repo);
    }

    private final void applyResources(PackRepository arg) {
        UMinecraft.getMinecraft().f_91066_.f_92117_.clear();
        UMinecraft.getMinecraft().f_91066_.f_92118_.clear();
        for (Object e : arg.m_10524_()) {
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type net.minecraft.server.packs.repository.Pack");
            Pack resourcePackInfo = (Pack)e;
            if (resourcePackInfo.m_10450_()) continue;
            UMinecraft.getMinecraft().f_91066_.f_92117_.add(resourcePackInfo.m_10446_());
            if (resourcePackInfo.m_10443_().m_10489_()) continue;
            UMinecraft.getMinecraft().f_91066_.f_92118_.add(resourcePackInfo.m_10446_());
        }
    }

    private final File getResourcePackFile(FilePackResources resourcePack) {
        Intrinsics.checkNotNull((Object)resourcePack, (String)"null cannot be cast to non-null type dev.dediamondpro.resourcify.mixins.AbstractResourcePackAccessor");
        File file = ((AbstractResourcePackAccessor)resourcePack).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        return file;
    }

    public final void saveSettings() {
        UMinecraft.getMinecraft().f_91066_.m_92169_();
    }
}

