/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.services.modrinth;

import com.google.gson.reflect.TypeToken;
import dev.dediamondpro.resourcify.libs.minemark.elementa.style.MarkdownStyle;
import dev.dediamondpro.resourcify.services.IProject;
import dev.dediamondpro.resourcify.services.ISearchData;
import dev.dediamondpro.resourcify.services.IService;
import dev.dediamondpro.resourcify.services.IVersion;
import dev.dediamondpro.resourcify.services.ProjectType;
import dev.dediamondpro.resourcify.services.ads.IAdProvider;
import dev.dediamondpro.resourcify.services.modrinth.FullModrinthProject;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthCategory;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthMinecraftVersion;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthSearchData;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthUpdateFormat;
import dev.dediamondpro.resourcify.services.modrinth.ModrinthVersion;
import dev.dediamondpro.resourcify.util.JsonUtil;
import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import dev.dediamondpro.resourcify.util.Utils;
import dev.dediamondpro.resourcify.util.UtilsKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJM\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J3\u0010\u0016\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00190\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0003J5\u0010\u001e\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00190\u00190\u00182\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b#\u0010\u0003J\u0017\u0010&\u001a\u00020\t2\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b&\u0010'J-\u0010*\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010)0\u0018\u0018\u00010(2\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b*\u0010+J)\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020)0\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016\u00a2\u0006\u0004\b-\u0010.J9\u00102\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u0001010\u00190\u00182\f\u00100\u001a\b\u0012\u0004\u0012\u00020/0\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b2\u00103J\u0015\u00104\u001a\u0004\u0018\u00010\u0004*\u00020\u0007H\u0002\u00a2\u0006\u0004\b4\u00105J\u001b\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0019H\u0016\u00a2\u0006\u0004\b6\u00107R\u0014\u00108\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b8\u00109R$\u0010\u000f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\u000e\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010;R$\u0010\u0010\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0\u000e\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010;\u00a8\u0006="}, d2={"Ldev/dediamondpro/resourcify/services/modrinth/ModrinthService;", "Ldev/dediamondpro/resourcify/services/IService;", "<init>", "()V", "", "getName", "()Ljava/lang/String;", "Ldev/dediamondpro/resourcify/services/ProjectType;", "type", "", "isProjectTypeSupported", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Z", "query", "sortBy", "", "minecraftVersions", "categories", "", "offset", "Ldev/dediamondpro/resourcify/services/ISearchData;", "search", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;ILdev/dediamondpro/resourcify/services/ProjectType;)Ldev/dediamondpro/resourcify/services/ISearchData;", "buildFacets", "(Ldev/dediamondpro/resourcify/services/ProjectType;Ljava/util/List;Ljava/util/List;)Ljava/lang/String;", "Ljava/util/concurrent/CompletableFuture;", "", "getMinecraftVersions", "()Ljava/util/concurrent/CompletableFuture;", "", "fetchMinecraftVersions", "getCategories", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/util/concurrent/CompletableFuture;", "category", "localizeCategory", "(Ljava/lang/String;)Ljava/lang/String;", "fetchCategories", "Ljava/net/URI;", "uri", "canFetchProjectUrl", "(Ljava/net/URI;)Z", "Lkotlin/Pair;", "Ldev/dediamondpro/resourcify/services/IProject;", "fetchProjectFromUrl", "(Ljava/net/URI;)Lkotlin/Pair;", "ids", "getProjectsFromIds", "(Ljava/util/List;)Ljava/util/Map;", "Ljava/io/File;", "files", "Ldev/dediamondpro/resourcify/services/IVersion;", "getUpdates", "(Ljava/util/List;Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/util/concurrent/CompletableFuture;", "getProjectType", "(Ldev/dediamondpro/resourcify/services/ProjectType;)Ljava/lang/String;", "getSortOptions", "()Ljava/util/Map;", "API", "Ljava/lang/String;", "Ldev/dediamondpro/resourcify/services/modrinth/ModrinthMinecraftVersion;", "Ljava/util/concurrent/CompletableFuture;", "Ldev/dediamondpro/resourcify/services/modrinth/ModrinthCategory;", "Resourcify (1.20.1-forge)-1.7.0"})
@SourceDebugExtension(value={"SMAP\nModrinthService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModrinthService.kt\ndev/dediamondpro/resourcify/services/modrinth/ModrinthService\n+ 2 NetworkUtil.kt\ndev/dediamondpro/resourcify/util/NetworkUtilKt\n+ 3 JsonUtil.kt\ndev/dediamondpro/resourcify/util/JsonUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,189:1\n173#2,5:190\n173#2,5:197\n173#2,5:220\n173#2,5:255\n173#2,5:263\n254#2,5:283\n232#2,4:288\n236#2,3:294\n239#2,2:299\n241#2,11:302\n35#3,2:195\n35#3,2:202\n35#3,2:225\n35#3,2:260\n35#3,2:268\n40#3,2:292\n35#3,2:313\n1202#4,2:204\n1230#4,2:206\n230#4,2:208\n1233#4:210\n774#4:211\n865#4,2:212\n1187#4,2:214\n1261#4,4:216\n774#4:227\n865#4,2:228\n1485#4:230\n1510#4,3:231\n1513#4,3:241\n1246#4,2:246\n1187#4,2:248\n1261#4,4:250\n1249#4:254\n1053#4:262\n1611#4,9:270\n1863#4:279\n1864#4:281\n1620#4:282\n381#5,7:234\n462#5:244\n412#5:245\n1#6:280\n1#6:301\n216#7,2:297\n126#7:315\n153#7,3:316\n*S KotlinDebug\n*F\n+ 1 ModrinthService.kt\ndev/dediamondpro/resourcify/services/modrinth/ModrinthService\n*L\n50#1:190,5\n149#1:197,5\n88#1:220,5\n114#1:255,5\n142#1:263,5\n165#1:283,5\n165#1:288,4\n165#1:294,3\n165#1:299,2\n165#1:302,11\n50#1:195,2\n149#1:202,2\n88#1:225,2\n114#1:260,2\n142#1:268,2\n165#1:292,2\n165#1:313,2\n150#1:204,2\n150#1:206,2\n150#1:208,2\n150#1:210\n79#1:211\n79#1:212,2\n80#1:214,2\n80#1:216,4\n96#1:227\n96#1:228,2\n97#1:230\n97#1:231,3\n97#1:241,3\n98#1:246,2\n99#1:248,2\n99#1:250,4\n98#1:254\n117#1:262\n155#1:270,9\n155#1:279\n155#1:281\n155#1:282\n97#1:234,7\n98#1:244\n98#1:245\n155#1:280\n165#1:301\n165#1:297,2\n169#1:315\n169#1:316,3\n*E\n"})
public final class ModrinthService
implements IService {
    @NotNull
    public static final ModrinthService INSTANCE = new ModrinthService();
    @NotNull
    public static final String API = "https://api.modrinth.com/v2";
    @Nullable
    private static CompletableFuture<List<ModrinthMinecraftVersion>> minecraftVersions;
    @Nullable
    private static CompletableFuture<List<ModrinthCategory>> categories;

    private ModrinthService() {
    }

    @Override
    @NotNull
    public String getName() {
        return "Modrinth";
    }

    @Override
    public boolean isProjectTypeSupported(@NotNull ProjectType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return this.getProjectType(type2) != null;
    }

    @Override
    @Nullable
    public ISearchData search(@NotNull String query, @NotNull String sortBy2, @NotNull List<String> minecraftVersions, @NotNull List<String> categories, int offset2, @NotNull ProjectType type2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortBy2, (String)"sortBy");
        Intrinsics.checkNotNullParameter(minecraftVersions, (String)"minecraftVersions");
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        URL uRL = new URIBuilder("https://api.modrinth.com/v2/search").setParameter("query", query).setParameter("facets", this.buildFacets(type2, minecraftVersions, categories)).setParameter("limit", "20").setParameter("offset", String.valueOf(offset2)).setParameter("index", sortBy2).build().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        URL $this$getJson_u24default$iv = uRL;
        boolean useCache$iv = true;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString($this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<ModrinthSearchData>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        return (ISearchData)object;
    }

    private final String buildFacets(ProjectType type2, List<String> minecraftVersions, List<String> categories) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildFacets_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildFacets_u24lambda_u242.append("[");
        $this$buildFacets_u24lambda_u242.append((String)(switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> "[\"project_type:datapack\"]";
            case 2 -> "[\"project_type:shader\"],[\"categories=iris\"]";
            case 3 -> "[\"project_type:shader\"],[\"categories=optifine\"]";
            default -> "[\"project_type:" + INSTANCE.getProjectType(type2) + "\"]";
        }));
        if (!((Collection)categories).isEmpty()) {
            $this$buildFacets_u24lambda_u242.append(",");
            $this$buildFacets_u24lambda_u242.append(CollectionsKt.joinToString$default((Iterable)categories, (CharSequence)",", null, null, (int)0, null, ModrinthService::buildFacets$lambda$2$lambda$0, (int)30, null));
        }
        if (!((Collection)minecraftVersions).isEmpty()) {
            $this$buildFacets_u24lambda_u242.append(",[");
            $this$buildFacets_u24lambda_u242.append(CollectionsKt.joinToString$default((Iterable)minecraftVersions, (CharSequence)",", null, null, (int)0, null, ModrinthService::buildFacets$lambda$2$lambda$1, (int)30, null));
            $this$buildFacets_u24lambda_u242.append("]");
        }
        $this$buildFacets_u24lambda_u242.append("]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public CompletableFuture<Map<String, String>> getMinecraftVersions() {
        this.fetchMinecraftVersions();
        CompletionStage<Object> completionStage = minecraftVersions;
        if (completionStage == null || (completionStage = completionStage.thenApply(arg_0 -> ModrinthService.getMinecraftVersions$lambda$6(ModrinthService::getMinecraftVersions$lambda$5, arg_0))) == null) {
            completionStage = MultiThreadingKt.supply(ModrinthService::getMinecraftVersions$lambda$7);
        }
        return completionStage;
    }

    private final void fetchMinecraftVersions() {
        if (minecraftVersions != null) {
            CompletableFuture<List<ModrinthMinecraftVersion>> completableFuture = minecraftVersions;
            boolean bl = completableFuture != null ? completableFuture.isDone() : false;
            if (bl) {
                CompletableFuture<List<ModrinthMinecraftVersion>> completableFuture2 = minecraftVersions;
                boolean bl2 = completableFuture2 != null ? !completableFuture2.isCompletedExceptionally() : false;
                if (bl2) {
                    return;
                }
            }
        }
        minecraftVersions = MultiThreadingKt.supplyAsync(ModrinthService::fetchMinecraftVersions$lambda$8);
    }

    @Override
    @NotNull
    public CompletableFuture<Map<String, Map<String, String>>> getCategories(@NotNull ProjectType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.fetchCategories();
        CompletionStage<Object> completionStage = categories;
        if (completionStage == null || (completionStage = completionStage.thenApply(arg_0 -> ModrinthService.getCategories$lambda$14(arg_0 -> ModrinthService.getCategories$lambda$13(type2, arg_0), arg_0))) == null) {
            completionStage = MultiThreadingKt.supply(ModrinthService::getCategories$lambda$15);
        }
        return completionStage;
    }

    private final String localizeCategory(String category) {
        String string = category.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return UtilsKt.localizeOrDefaultExtension("resourcify.categories." + StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null), UtilsKt.capitalizeAll(category), new Object[0]);
    }

    private final void fetchCategories() {
        if (categories != null) {
            CompletableFuture<List<ModrinthCategory>> completableFuture = categories;
            boolean bl = completableFuture != null ? completableFuture.isDone() : false;
            if (bl) {
                CompletableFuture<List<ModrinthCategory>> completableFuture2 = categories;
                boolean bl2 = completableFuture2 != null ? !completableFuture2.isCompletedExceptionally() : false;
                if (bl2) {
                    return;
                }
            }
        }
        categories = MultiThreadingKt.supplyAsync(ModrinthService::fetchCategories$lambda$16).thenApply(arg_0 -> ModrinthService.fetchCategories$lambda$19(ModrinthService::fetchCategories$lambda$18, arg_0));
    }

    @Override
    public boolean canFetchProjectUrl(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)uri.getHost(), (Object)"modrinth.com");
    }

    @Override
    @Nullable
    public Pair<ProjectType, CompletableFuture<IProject>> fetchProjectFromUrl(@NotNull URI uri) {
        ProjectType projectType;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String[] stringArray = new String[]{"/"};
        List path = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)string, (CharSequence)"/"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (path.size() < 2) {
            return null;
        }
        switch ((String)path.get(0)) {
            case "resourcepack": {
                projectType = ProjectType.RESOURCE_PACK;
                break;
            }
            case "datapack": {
                projectType = ProjectType.DATA_PACK;
                break;
            }
            case "shaders": {
                projectType = ProjectType.IRIS_SHADER;
                break;
            }
            case "mod": 
            case "plugin": 
            case "modpack": {
                projectType = ProjectType.UNKNOWN;
                break;
            }
            default: {
                return null;
            }
        }
        ProjectType type2 = projectType;
        URL uRL = NetworkUtilKt.toURL("https://api.modrinth.com/v2/project/" + path.get(1));
        if (uRL == null) {
            return null;
        }
        URL url = uRL;
        return TuplesKt.to((Object)((Object)type2), MultiThreadingKt.supplyAsync(() -> ModrinthService.fetchProjectFromUrl$lambda$20(url)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, IProject> getProjectsFromIds(@NotNull List<String> ids) {
        void $this$associateByTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        String idString = CollectionsKt.joinToString$default((Iterable)ids, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, ModrinthService::getProjectsFromIds$lambda$21, (int)24, null);
        URL uRL = new URIBuilder("https://api.modrinth.com/v2/projects").setParameter("ids", idString).build().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        URL $this$getJson_u24default$iv = uRL;
        boolean useCache$iv = true;
        int attempts$iv = 3;
        Object headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString($this$getJson_u24default$iv, useCache$iv, attempts$iv, (Map<String, String>)headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<List<? extends FullModrinthProject>>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        Intrinsics.checkNotNull(object);
        Iterable $this$associateBy$iv = (Iterable)object;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        headers$iv = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Object element$iv2;
            Map map2;
            block4: {
                FullModrinthProject fullModrinthProject = (FullModrinthProject)element$iv$iv;
                map2 = destination$iv$iv;
                boolean bl = false;
                Iterable $this$first$iv = ids;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    void project;
                    String it = (String)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)project.getId(), (Object)it)) continue;
                    break block4;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            map2.put((String)element$iv2, element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Override
    @NotNull
    public CompletableFuture<Map<File, IVersion>> getUpdates(@NotNull List<? extends File> files, @NotNull ProjectType type2) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return MultiThreadingKt.supplyAsync(() -> ModrinthService.getUpdates$lambda$26(files, type2));
    }

    private final String getProjectType(ProjectType $this$getProjectType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getProjectType.ordinal()]) {
            case 4 -> "resourcepack";
            case 5 -> "resourcepack";
            case 1 -> "mod";
            case 2 -> "shader";
            case 3 -> "shader";
            default -> null;
        };
    }

    @Override
    @NotNull
    public Map<String, String> getSortOptions() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"relevance", (Object)"resourcify.browse.sort.relevance"), TuplesKt.to((Object)"downloads", (Object)"resourcify.browse.sort.downloads"), TuplesKt.to((Object)"follows", (Object)"resourcify.browse.sort.follows"), TuplesKt.to((Object)"newest", (Object)"resourcify.browse.sort.newest"), TuplesKt.to((Object)"updated", (Object)"resourcify.browse.sort.updated")};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public boolean canSelectMultipleMinecraftVersions() {
        return IService.DefaultImpls.canSelectMultipleMinecraftVersions(this);
    }

    @Override
    @NotNull
    public IAdProvider getAdProvider() {
        return IService.DefaultImpls.getAdProvider(this);
    }

    @Override
    @NotNull
    public MarkdownStyle getMarkdownStyle() {
        return IService.DefaultImpls.getMarkdownStyle(this);
    }

    private static final CharSequence buildFacets$lambda$2$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "[\"categories:'" + it + "'\"]";
    }

    private static final CharSequence buildFacets$lambda$2$lambda$1(String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return "\"versions:" + version + "\"";
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getMinecraftVersions$lambda$5(List it) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$filter$iv = it;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModrinthMinecraftVersion version = (ModrinthMinecraftVersion)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)version.getVersionType(), (Object)"release")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            ModrinthMinecraftVersion version = (ModrinthMinecraftVersion)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)version.getVersion(), (Object)version.getVersion());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private static final Map getMinecraftVersions$lambda$6(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map getMinecraftVersions$lambda$7() {
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchMinecraftVersions$lambda$8() {
        Object object;
        void $this$getJson_u24default$iv;
        URL uRL = new URL("https://api.modrinth.com/v2/tag/game_version");
        boolean useCache$iv = false;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString((URL)$this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<List<? extends ModrinthMinecraftVersion>>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        List list = (List)object;
        if (list == null) {
            throw new IllegalStateException("Failed to fetch Minecraft versions.".toString());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getCategories$lambda$13(ProjectType $type, List it) {
        void $this$mapValuesTo$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        ModrinthCategory category;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNull((Object)it);
        Iterable $this$filter$iv = it;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            category = (ModrinthCategory)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)category.getProjectType(), (Object)INSTANCE.getProjectType($type))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            category = (ModrinthCategory)element$iv$iv;
            boolean bl = false;
            key$iv$iv = INSTANCE.localizeCategory(category.getHeader());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$associateTo$iv$iv;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object2 = object;
            boolean bl3 = false;
            List categories = (List)entry.getValue();
            Iterable $this$associate$iv = categories;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable2 = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                ModrinthCategory category2 = (ModrinthCategory)element$iv$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to((Object)category2.getName(), (Object)INSTANCE.localizeCategory(category2.getName()));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map map3 = destination$iv$iv2;
            object2.put(k, map3);
        }
        return destination$iv$iv;
    }

    private static final Map getCategories$lambda$14(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map getCategories$lambda$15() {
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchCategories$lambda$16() {
        Object object;
        void $this$getJson_u24default$iv;
        URL uRL = new URL("https://api.modrinth.com/v2/tag/category");
        boolean useCache$iv = false;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString((URL)$this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<List<? extends ModrinthCategory>>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        List list = (List)object;
        if (list == null) {
            throw new IllegalStateException("Failed to fetch categories.".toString());
        }
        return list;
    }

    private static final List fetchCategories$lambda$18(List it) {
        List list = it;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Object object;
                String string;
                Regex regex;
                Object object2;
                ModrinthCategory category = (ModrinthCategory)a;
                boolean bl = false;
                String string2 = category.getHeader();
                CharSequence charSequence = category.getName();
                if (!new Regex("^[0-9].*").matches(charSequence)) {
                    object2 = "\uffff" + category.getName();
                } else {
                    charSequence = category.getName();
                    regex = new Regex("[^0-9]");
                    string = "";
                    object2 = Character.valueOf((char)Integer.parseInt(regex.replace(charSequence, string)));
                }
                category = (ModrinthCategory)b;
                Comparable comparable = (Comparable)((Object)(string2 + object2));
                bl = false;
                String string3 = category.getHeader();
                charSequence = category.getName();
                if (!new Regex("^[0-9].*").matches(charSequence)) {
                    object = "\uffff" + category.getName();
                } else {
                    charSequence = category.getName();
                    regex = new Regex("[^0-9]");
                    string = "";
                    object = Character.valueOf((char)Integer.parseInt(regex.replace(charSequence, string)));
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)(string3 + object))));
            }
        });
    }

    private static final List fetchCategories$lambda$19(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final IProject fetchProjectFromUrl$lambda$20(URL $url) {
        Object object;
        URL $this$getJson_u24default$iv = $url;
        boolean useCache$iv = true;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString($this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<FullModrinthProject>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        return (IProject)object;
    }

    private static final CharSequence getProjectsFromIds$lambda$21(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Map getUpdates$lambda$26(List $files, ProjectType $type) {
        void $this$mapTo$iv$iv;
        Map data;
        Object object;
        String string;
        Map data$iv;
        Map hashes;
        block28: {
            void $this$postAndGetJson_u24default$iv;
            Object it$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = $files;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo232 = false;
            List $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String hash;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                File it = (File)element$iv$iv;
                boolean bl2 = false;
                String string2 = hash = Utils.INSTANCE.getSha1(it);
                if ((string2 == null ? null : TuplesKt.to((Object)string2, (Object)it)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            hashes = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            String loader = switch (WhenMappings.$EnumSwitchMapping$0[$type.ordinal()]) {
                case 4, 5 -> "minecraft";
                case 2 -> "iris";
                case 3 -> "optifine";
                default -> throw new IllegalStateException(($type + " is not supported in updates").toString());
            };
            destination$iv$iv = new URL("https://api.modrinth.com/v2/version_files/update");
            Object $i$f$mapNotNullTo232 = CollectionsKt.listOf((Object)loader);
            $this$forEach$iv$iv$iv = CollectionsKt.toList((Iterable)hashes.keySet());
            $i$f$mapNotNullTo232 = new ModrinthUpdateFormat($this$forEach$iv$iv$iv, (List)$i$f$mapNotNullTo232, null, null, 12, null);
            int attempts$iv = 3;
            Map headers$iv = MapsKt.emptyMap();
            boolean $i$f$postAndGetJson = false;
            void $this$postAndGetString$iv$iv = $this$postAndGetJson_u24default$iv;
            boolean $i$f$postAndGetString = false;
            for (int i$iv$iv = 0; i$iv$iv < attempts$iv; ++i$iv$iv) {
                block27: {
                    try {
                        String result$iv$iv;
                        Object object2;
                        String output$iv$iv;
                        HttpsURLConnection con$iv$iv = NetworkUtilKt.setupConnection((URL)$this$postAndGetString$iv$iv);
                        void $this$toJson$iv$iv$iv = data$iv;
                        boolean $i$f$toJson = false;
                        Object type$iv$iv$iv = new TypeToken<ModrinthUpdateFormat>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)JsonUtil.INSTANCE.getGson().toJson((Object)$this$toJson$iv$iv$iv, (Type)type$iv$iv$iv), (String)"toJson(...)");
                        con$iv$iv.setRequestProperty("Content-Type", "application/json");
                        con$iv$iv.setRequestProperty("Content-Length", String.valueOf(output$iv$iv.length()));
                        Object $this$forEach$iv$iv$iv2 = headers$iv;
                        boolean $i$f$forEach2 = false;
                        for (Map.Entry entry : $this$forEach$iv$iv$iv2.entrySet()) {
                            object2 = entry;
                            boolean bl = false;
                            String key$iv$iv = (String)object2.getKey();
                            String value$iv$iv = (String)object2.getValue();
                            con$iv$iv.setRequestProperty(key$iv$iv, value$iv$iv);
                        }
                        con$iv$iv.setDoOutput(true);
                        OutputStream outputStream = con$iv$iv.getOutputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
                        $this$forEach$iv$iv$iv2 = outputStream;
                        Object object3 = Charsets.UTF_8;
                        type$iv$iv$iv = new OutputStreamWriter((OutputStream)$this$forEach$iv$iv$iv2, (Charset)object3);
                        int n = 8192;
                        $this$forEach$iv$iv$iv2 = type$iv$iv$iv instanceof BufferedWriter ? (BufferedWriter)type$iv$iv$iv : new BufferedWriter((Writer)type$iv$iv$iv, n);
                        object3 = null;
                        try {
                            it$iv$iv = (BufferedWriter)$this$forEach$iv$iv$iv2;
                            boolean closeable = false;
                            ((Writer)it$iv$iv).write(output$iv$iv);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            object3 = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)$this$forEach$iv$iv$iv2, (Throwable)object3);
                        }
                        if (NetworkUtilKt.getEncodedInputStream(con$iv$iv) != null) {
                            InputStream inputStream;
                            object2 = Charsets.UTF_8;
                            Reader bl = new InputStreamReader(inputStream, (Charset)object2);
                            int key$iv$iv = 8192;
                            Closeable closeable = bl instanceof BufferedReader ? (BufferedReader)bl : new BufferedReader(bl, key$iv$iv);
                            object2 = null;
                            try {
                                BufferedReader it$iv$iv2 = (BufferedReader)closeable;
                                boolean bl4 = false;
                                String string3 = TextStreamsKt.readText((Reader)it$iv$iv2);
                                v3 = string3;
                            }
                            catch (Throwable throwable) {
                                object2 = throwable;
                                throw throwable;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                            }
                        } else {
                            v3 = result$iv$iv = null;
                        }
                        if (result$iv$iv == null) break block27;
                        string = result$iv$iv;
                        break block28;
                    }
                    catch (Exception e$iv$iv) {
                        e$iv$iv.printStackTrace();
                    }
                }
                Thread.sleep(250L);
            }
            string = null;
        }
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<Map<String, ? extends ModrinthVersion>>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        Map map2 = (Map)object;
        if (map2 == null) {
            throw new IllegalStateException("Failed to fetch updates".toString());
        }
        Map $this$map$iv = data = map2;
        boolean $i$f$map = false;
        data$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry $i$f$fromJson = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = hashes.get(it.getKey());
            Intrinsics.checkNotNull(v);
            collection.add(TuplesKt.to(v, Intrinsics.areEqual(it.getKey(), (Object)((ModrinthVersion)it.getValue()).getSha1()) ? null : (ModrinthVersion)it.getValue()));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectType.values().length];
            try {
                nArray[ProjectType.DATA_PACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.IRIS_SHADER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.OPTIFINE_SHADER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.RESOURCE_PACK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectType.AYCY_RESOURCE_PACK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

