/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import dev.dediamondpro.resourcify.util.DownloadData;
import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import dev.dediamondpro.resourcify.util.QueuedDownload;
import dev.dediamondpro.resourcify.util.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JE\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003R\u0014\u0010\u0017\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001d0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001c\u00a8\u0006\u001f"}, d2={"Ldev/dediamondpro/resourcify/util/DownloadManager;", "", "<init>", "()V", "Ljava/io/File;", "file", "", "sha512", "Ljava/net/URL;", "url", "", "extract", "Lkotlin/Function0;", "", "callback", "download", "(Ljava/io/File;Ljava/lang/String;Ljava/net/URL;ZLkotlin/jvm/functions/Function0;)V", "", "getProgress", "(Ljava/net/URL;)Ljava/lang/Float;", "cancelDownload", "(Ljava/net/URL;)V", "downloadNext", "tempFolder", "Ljava/io/File;", "", "Ldev/dediamondpro/resourcify/util/QueuedDownload;", "queuedDownloads", "Ljava/util/Map;", "Ldev/dediamondpro/resourcify/util/DownloadData;", "downloadsInProgress", "Resourcify (1.20.1-forge)-1.7.0"})
@SourceDebugExtension(value={"SMAP\nDownloadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadManager.kt\ndev/dediamondpro/resourcify/util/DownloadManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1317#2:147\n1318#2:149\n1#3:148\n*S KotlinDebug\n*F\n+ 1 DownloadManager.kt\ndev/dediamondpro/resourcify/util/DownloadManager\n*L\n105#1:147\n105#1:149\n*E\n"})
public final class DownloadManager {
    @NotNull
    public static final DownloadManager INSTANCE = new DownloadManager();
    @NotNull
    private static final File tempFolder = new File("./resourcify-temp");
    @NotNull
    private static final Map<URL, QueuedDownload> queuedDownloads = new LinkedHashMap();
    @NotNull
    private static final Map<URL, DownloadData> downloadsInProgress = new LinkedHashMap();

    private DownloadManager() {
    }

    public final void download(@NotNull File file, @Nullable String sha512, @NotNull URL url, boolean extract, @Nullable Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        queuedDownloads.put(url, new QueuedDownload(file, sha512, extract, callback));
        this.downloadNext();
    }

    public static /* synthetic */ void download$default(DownloadManager downloadManager, File file, String string, URL uRL, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            function0 = null;
        }
        downloadManager.download(file, string, uRL, bl, (Function0<Unit>)function0);
    }

    @Nullable
    public final Float getProgress(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (queuedDownloads.containsKey(url)) {
            return Float.valueOf(0.0f);
        }
        if (!downloadsInProgress.containsKey(url)) {
            return null;
        }
        Object object = downloadsInProgress.get(url);
        if (object == null || (object = ((DownloadData)object).getLength()) == null) {
            return Float.valueOf(0.0f);
        }
        int length = (Integer)object;
        Object object2 = downloadsInProgress.get(url);
        return Float.valueOf((object2 != null && (object2 = ((DownloadData)object2).getFile()) != null ? (float)((File)object2).length() : 0.0f) / (float)length);
    }

    public final void cancelDownload(@NotNull URL url) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (queuedDownloads.containsKey(url)) {
            queuedDownloads.remove(url);
            return;
        }
        if (!downloadsInProgress.containsKey(url)) {
            return;
        }
        Object object2 = downloadsInProgress.get(url);
        if (object2 != null && (object2 = ((DownloadData)object2).getFuture()) != null) {
            ((CompletableFuture)object2).cancel(true);
        }
        if ((object = downloadsInProgress.get(url)) != null && (object = ((DownloadData)object).getFile()) != null) {
            ((File)object).delete();
        }
        downloadsInProgress.remove(url);
    }

    private final void downloadNext() {
        if (downloadsInProgress.size() >= 2) {
            return;
        }
        URL uRL = (URL)CollectionsKt.firstOrNull((Iterable)queuedDownloads.keySet());
        if (uRL == null) {
            return;
        }
        URL url = uRL;
        QueuedDownload queuedDownload = queuedDownloads.remove(url);
        if (queuedDownload == null) {
            return;
        }
        QueuedDownload queuedDownload2 = queuedDownload;
        tempFolder.mkdirs();
        Ref.ObjectRef tempFile = new Ref.ObjectRef();
        tempFile.element = new File(tempFolder, queuedDownload2.getFile().getName() + ".tmp");
        int i2 = 0;
        while (((File)tempFile.element).exists()) {
            tempFile.element = new File(tempFolder, queuedDownload2.getFile().getName() + "-" + i2 + ".tmp");
        }
        Map<URL, DownloadData> map2 = downloadsInProgress;
        CompletionStage completionStage = MultiThreadingKt.runAsync(() -> DownloadManager.downloadNext$lambda$7(url, queuedDownload2, tempFile)).whenComplete((arg_0, arg_1) -> DownloadManager.downloadNext$lambda$9((arg_0, arg_1) -> DownloadManager.downloadNext$lambda$8(url, tempFile, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
        DownloadData downloadData = new DownloadData((CompletableFuture)completionStage, (File)tempFile.element, null, 4, null);
        map2.put(url, downloadData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void downloadNext$lambda$7(URL $url, QueuedDownload $queuedDownload, Ref.ObjectRef $tempFile) {
        block28: {
            HttpsURLConnection con = NetworkUtilKt.setupConnection($url);
            DownloadData downloadData = downloadsInProgress.get($url);
            if (downloadData != null) {
                downloadData.setLength(con.getContentLength());
            }
            CopyOption[] copyOptionArray = (CopyOption[])NetworkUtilKt.getEncodedInputStream(con);
            Object object = null;
            try {
                InputStream it22 = (InputStream)copyOptionArray;
                boolean bl = false;
                InputStream inputStream = it22;
                Intrinsics.checkNotNull((Object)inputStream);
                CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long it22 = Files.copy(inputStream, ((File)$tempFile.element).toPath(), copyOptionArray2);
            }
            catch (Throwable it22) {
                object = it22;
                throw it22;
            }
            finally {
                CloseableKt.closeFinally((Closeable)copyOptionArray, (Throwable)object);
            }
            String string = $queuedDownload.getSha1();
            if (string != null) {
                String it = string;
                boolean bl = false;
                String hash = Utils.INSTANCE.getSha1((File)$tempFile.element);
                if (!Intrinsics.areEqual((Object)hash, (Object)it)) {
                    ((File)$tempFile.element).delete();
                    throw new IllegalStateException(("Hash " + hash + " does not match expected hash " + it + "!").toString());
                }
            }
            if ($queuedDownload.getExtract()) {
                File targetFolder = $queuedDownload.getFile();
                targetFolder.mkdirs();
                object = (Closeable)new ZipFile((File)$tempFile.element);
                Throwable it = null;
                try {
                    void $this$forEach$iv;
                    ZipFile zip = (ZipFile)object;
                    boolean bl = false;
                    String prefixToRemove = null;
                    Enumeration enumeration = zip.getEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getEntries(...)");
                    Iterator iterator = CollectionsKt.iterator((Enumeration)enumeration);
                    while (iterator.hasNext()) {
                        ZipArchiveEntry entry = (ZipArchiveEntry)iterator.next();
                        String string2 = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        String firstFolder = StringsKt.substringBefore((String)string2, (String)"/", (String)"");
                        if (((CharSequence)firstFolder).length() == 0) continue;
                        if (prefixToRemove == null) {
                            prefixToRemove = firstFolder + "/";
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)prefixToRemove, (Object)(firstFolder + "/"))) continue;
                        prefixToRemove = null;
                        break;
                    }
                    Enumeration enumeration2 = zip.getEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)enumeration2, (String)"getEntries(...)");
                    iterator = SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration2));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String entryName;
                        File entryFile;
                        String string3;
                        ZipArchiveEntry entry = (ZipArchiveEntry)element$iv;
                        boolean bl2 = false;
                        String it2 = entry.getName();
                        boolean bl3 = false;
                        if (prefixToRemove != null) {
                            Intrinsics.checkNotNull((Object)it2);
                            string3 = StringsKt.removePrefix((String)it2, (CharSequence)prefixToRemove);
                        } else {
                            string3 = it2;
                        }
                        if (FilesKt.startsWith((File)(entryFile = new File(targetFolder, entryName = string3)), (String)"..") || FilesKt.startsWith((File)entryFile, (String)"/")) {
                            throw new IllegalStateException(("Safety measure tripped for " + entryFile + ", it is trying to go to parent directory").toString());
                        }
                        if (entry.isDirectory()) {
                            entryFile.mkdirs();
                            continue;
                        }
                        entryFile.getParentFile().mkdirs();
                        Closeable closeable = zip.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            InputStream it3 = (InputStream)closeable;
                            boolean bl4 = false;
                            CopyOption[] copyOptionArray3 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            Files.copy(it3, entryFile.toPath(), copyOptionArray3);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    zip = Unit.INSTANCE;
                }
                catch (Throwable zip) {
                    it = zip;
                    throw zip;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)it);
                }
            } else {
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.move(((File)$tempFile.element).toPath(), $queuedDownload.getFile().toPath(), copyOptionArray);
            }
            ((File)$tempFile.element).delete();
            Function0<Unit> function0 = $queuedDownload.getCallback();
            if (function0 == null) break block28;
            Function0<Unit> it = function0;
            boolean bl = false;
            it.invoke();
        }
    }

    private static final Unit downloadNext$lambda$8(URL $url, Ref.ObjectRef $tempFile, Void void_, Throwable throwable) {
        if (throwable != null) {
            System.out.println((Object)("Download of " + $url + " failed:"));
            throwable.printStackTrace();
            ((File)$tempFile.element).delete();
            return Unit.INSTANCE;
        }
        downloadsInProgress.remove($url);
        INSTANCE.downloadNext();
        return Unit.INSTANCE;
    }

    private static final void downloadNext$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

