/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\u0004\b\u0000\u0010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0015\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ldev/dediamondpro/resourcify/util/MultiThreading;", "", "<init>", "()V", "U", "Ljava/util/function/Supplier;", "supplier", "Ljava/util/concurrent/CompletableFuture;", "supplyAsync", "(Ljava/util/function/Supplier;)Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Runnable;", "runnable", "Ljava/lang/Void;", "runAsync", "(Ljava/lang/Runnable;)Ljava/util/concurrent/CompletableFuture;", "r", "Ljava/lang/Thread;", "createThread", "(Ljava/lang/Runnable;)Ljava/lang/Thread;", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "pool", "Ljava/util/concurrent/ExecutorService;", "Resourcify (1.20.1-forge)-1.7.0"})
public final class MultiThreading {
    @NotNull
    public static final MultiThreading INSTANCE = new MultiThreading();
    private static final ExecutorService pool = Executors.newCachedThreadPool(INSTANCE::createThread);

    private MultiThreading() {
    }

    @NotNull
    public final <U> CompletableFuture<U> supplyAsync(@NotNull Supplier<U> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        CompletableFuture<U> completableFuture = CompletableFuture.supplyAsync(supplier, pool);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @NotNull
    public final CompletableFuture<Void> runAsync(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(runnable, pool);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
        return completableFuture;
    }

    private final Thread createThread(Runnable r) {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        Intrinsics.checkNotNull((Object)thread);
        return thread;
    }
}

