/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.model;

import com.vicmatskiv.pointblank.client.controller.BlendingAnimationProcessor;
import com.vicmatskiv.pointblank.item.GunItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.GeckoLibException;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreBakedGeoModel;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.model.DefaultedItemGeoModel;

public class GunGeoModel
extends DefaultedItemGeoModel<GunItem> {
    private BakedGeoModel currentModel = null;
    private final List<ResourceLocation> fallbackAnimations;
    private final BlendingAnimationProcessor<GunItem> anotherAnimationProcessor = new BlendingAnimationProcessor(this);

    public GunGeoModel(ResourceLocation assetSubpath, List<ResourceLocation> fallbackAnimations) {
        super(assetSubpath);
        this.fallbackAnimations = new ArrayList<ResourceLocation>();
        for (ResourceLocation fallbackAnimation : fallbackAnimations) {
            this.fallbackAnimations.add(this.buildFormattedAnimationPath(fallbackAnimation));
        }
    }

    public AnimationProcessor<GunItem> getAnimationProcessor() {
        return this.anotherAnimationProcessor;
    }

    public BakedGeoModel getBakedModel(ResourceLocation location) {
        BakedGeoModel model = (BakedGeoModel)GeckoLibCache.getBakedModels().get(location);
        if (model == null) {
            throw new GeckoLibException(location, "Unable to find model");
        }
        if (model != this.currentModel) {
            this.anotherAnimationProcessor.setActiveModel((CoreBakedGeoModel)model);
            this.currentModel = model;
        }
        return this.currentModel;
    }

    public Animation getAnimation(GunItem animatable, String name) {
        ResourceLocation location = this.getAnimationResource((GeoAnimatable)animatable);
        BakedAnimations bakedAnimations = (BakedAnimations)GeckoLibCache.getBakedAnimations().get(location);
        Animation bakedAnimation = null;
        if (bakedAnimations != null) {
            bakedAnimation = bakedAnimations.getAnimation(name);
        }
        if (bakedAnimation == null) {
            for (ResourceLocation animationLocation : this.fallbackAnimations) {
                BakedAnimations altAnimations = (BakedAnimations)GeckoLibCache.getBakedAnimations().get(animationLocation);
                if (altAnimations == null || (bakedAnimation = altAnimations.getAnimation(name)) == null) continue;
                break;
            }
        }
        return bakedAnimation;
    }
}

