/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.inventory;

import com.vicmatskiv.pointblank.Enableable;
import com.vicmatskiv.pointblank.block.entity.PrinterBlockEntity;
import com.vicmatskiv.pointblank.crafting.PointBlankIngredient;
import com.vicmatskiv.pointblank.crafting.PointBlankRecipe;
import com.vicmatskiv.pointblank.inventory.IngredientSlot;
import com.vicmatskiv.pointblank.inventory.SearchSlot;
import com.vicmatskiv.pointblank.registry.ItemRegistry;
import com.vicmatskiv.pointblank.registry.MenuRegistry;
import com.vicmatskiv.pointblank.util.InventoryUtils;
import com.vicmatskiv.pointblank.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.searchtree.FullTextSearchTree;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.util.ClientUtils;

public class CraftingContainerMenu
extends AbstractContainerMenu {
    private static final int SEARCH_COLS = 6;
    private static final int SEARCH_ROWS = 7;
    private static final int INGREDIENT_COLS = 5;
    private static final int INGREDIENT_ROWS = 2;
    public static final SimpleContainer INGREDIENT_CONTAINER = new SimpleContainer(10);
    public static final SimpleContainer SEARCH_CONTAINER = new SimpleContainer(42);
    private final NonNullList<ItemStack> items = NonNullList.m_122779_();
    private final AbstractContainerMenu inventoryMenu;
    private List<ItemStack> displayItems = new ArrayList<ItemStack>();
    private PrinterBlockEntity craftingBlockEntity;
    private ContainerData containerData;
    private FullTextSearchTree<ItemStack> searchTree;
    private Player player;

    public CraftingContainerMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, null, (ContainerData)new SimpleContainerData(2));
    }

    public CraftingContainerMenu(int containerId, Inventory playerInventory, PrinterBlockEntity craftingBlockEntity, ContainerData dataAccess) {
        super((MenuType)MenuRegistry.CRAFTING.get(), containerId);
        Slot slot;
        int j;
        int i;
        this.craftingBlockEntity = craftingBlockEntity;
        this.containerData = dataAccess;
        this.player = playerInventory.f_35978_;
        this.inventoryMenu = playerInventory.f_35978_.f_36095_;
        this.m_38884_(dataAccess);
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 6; ++j) {
                slot = new SearchSlot((Container)SEARCH_CONTAINER, i * 6 + j, 9 + j * 18, 18 + i * 18, true);
                this.m_38897_(slot);
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 5; ++j) {
                slot = new IngredientSlot((Container)INGREDIENT_CONTAINER, i * 5 + j, 151 + j * 18, 108 + i * 18);
                this.m_38897_(slot);
            }
        }
        for (Supplier<? extends Item> itemSupplier : ItemRegistry.ITEMS.getItemsByName().values()) {
            Enableable e;
            Item item = itemSupplier.get();
            PointBlankRecipe recipe = PointBlankRecipe.getRecipe(playerInventory.f_35978_.m_9236_(), item);
            if (recipe == null || item instanceof Enableable && !(e = (Enableable)item).isEnabled()) continue;
            this.displayItems.add(recipe.getInitializedStack());
        }
        if (MiscUtil.isClientSide((Entity)playerInventory.f_35978_)) {
            this.searchTree = new FullTextSearchTree(itemStack -> itemStack.m_41651_((Player)null, (TooltipFlag)TooltipFlag.Default.f_256752_.m_257777_()).stream().map(component -> ChatFormatting.m_126649_((String)component.getString()).trim()).filter(p_210809_ -> !p_210809_.isEmpty()), itemStack -> Stream.of(BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_())), this.displayItems);
            this.searchTree.m_214078_();
        }
        this.scrollTo(0.0f);
    }

    public PrinterBlockEntity getWorkstationBlockEntity() {
        return this.craftingBlockEntity;
    }

    public void m_182406_(int slotIndex, int stateId, ItemStack itemStack) {
        super.m_182406_(slotIndex, stateId, itemStack);
    }

    public void m_182410_(int stateId, List<ItemStack> itemStacks, ItemStack carriedStack) {
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    protected int calculateRowCount() {
        return Mth.m_184652_((int)this.items.size(), (int)6) - 7;
    }

    public int getRowIndexForScroll(float scroll) {
        return Math.max((int)((double)(scroll * (float)this.calculateRowCount()) + 0.5), 0);
    }

    public float getScrollForRowIndex(int rowIndex) {
        return Mth.m_14036_((float)((float)rowIndex / (float)this.calculateRowCount()), (float)0.0f, (float)1.0f);
    }

    public float subtractInputFromScroll(float scrolloffs, double scroll) {
        return Mth.m_14036_((float)(scrolloffs - (float)(scroll / (double)this.calculateRowCount())), (float)0.0f, (float)1.0f);
    }

    public void scrollTo(float scroll) {
        int i = this.getRowIndexForScroll(scroll);
        for (int j = 0; j < 7; ++j) {
            for (int k = 0; k < 6; ++k) {
                int l = k + (j + i) * 6;
                if (l >= 0 && l < this.items.size()) {
                    SEARCH_CONTAINER.m_6836_(k + j * 6, (ItemStack)this.items.get(l));
                    continue;
                }
                SEARCH_CONTAINER.m_6836_(k + j * 6, ItemStack.f_41583_);
            }
        }
    }

    public boolean canScroll() {
        return this.items.size() > 42;
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot;
        if (slotIndex >= this.f_38839_.size() - 6 && slotIndex < this.f_38839_.size() && (slot = (Slot)this.f_38839_.get(slotIndex)) != null && slot.m_6657_()) {
            slot.m_269060_(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_5882_(ItemStack itemStack, Slot slot) {
        return slot.f_40218_ != SEARCH_CONTAINER;
    }

    public boolean m_5622_(Slot p_98653_) {
        return p_98653_.f_40218_ != SEARCH_CONTAINER;
    }

    public ItemStack m_142621_() {
        return this.inventoryMenu.m_142621_();
    }

    public void m_142503_(ItemStack itemStack) {
        this.inventoryMenu.m_142503_(itemStack);
    }

    public void refreshSearchResults(String s) {
        this.items.clear();
        if (s.isEmpty()) {
            this.items.addAll(this.displayItems);
        } else {
            this.items.addAll((Collection)this.searchTree.m_6293_(s.toLowerCase(Locale.ROOT)));
        }
        this.scrollTo(0.0f);
    }

    public boolean updateIngredientSlots(PointBlankRecipe selectedItemRecipe) {
        boolean isCraftable = true;
        List<PointBlankIngredient> ingredients = selectedItemRecipe.getPointBlankIngredients();
        if (ingredients.size() <= INGREDIENT_CONTAINER.m_6643_()) {
            int ingredientSlotOffset = SEARCH_CONTAINER.m_6643_();
            for (int i = 0; i < ingredients.size(); ++i) {
                PointBlankIngredient ingredient = ingredients.get(i);
                IngredientSlot ingredientSlot = (IngredientSlot)((Object)this.f_38839_.get(ingredientSlotOffset + i));
                ClientUtils.getClientPlayer();
                boolean hasIngredient = InventoryUtils.hasIngredient(ClientUtils.getClientPlayer(), ingredient);
                ingredientSlot.setIngredient(ingredient, hasIngredient);
                isCraftable &= hasIngredient;
            }
        }
        return isCraftable;
    }

    public void clearIngredientSlots() {
        int ingredientSlotOffset = SEARCH_CONTAINER.m_6643_();
        for (int i = 0; i < INGREDIENT_CONTAINER.m_6643_(); ++i) {
            IngredientSlot ingredientSlot = (IngredientSlot)((Object)this.f_38839_.get(ingredientSlotOffset + i));
            ingredientSlot.setIngredient(null, true);
        }
        INGREDIENT_CONTAINER.m_6211_();
    }

    public boolean isCreativeSlot(Slot slot) {
        return slot != null && slot.f_40218_ == SEARCH_CONTAINER;
    }

    public boolean isIdle() {
        return PrinterBlockEntity.State.values()[this.containerData.m_6413_(0)] == PrinterBlockEntity.State.IDLE;
    }

    public boolean isCrafting() {
        boolean result = false;
        PrinterBlockEntity.State state = PrinterBlockEntity.State.values()[this.containerData.m_6413_(0)];
        if (state == PrinterBlockEntity.State.CRAFTING) {
            Level level = MiscUtil.getLevel((Entity)this.player);
            int playerEntityId = this.containerData.m_6413_(1);
            if (playerEntityId >= 0) {
                result = this.player == level.m_6815_(playerEntityId);
            }
        }
        return result;
    }
}

