/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.mixin.StructureTemplatePoolMixin;
import com.vicmatskiv.pointblank.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class VillagerRegistry {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((ResourceKey)Registries.f_256749_, (String)"pointblank");
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256805_, (String)"pointblank");
    public static RegistryObject<PoiType> ARMS_DEALER_POI = VillagerRegistry.registerPoiType("arms_dealer", () -> (Block)BlockRegistry.WORKSTATION.get(), 1, 1);
    public static RegistryObject<VillagerProfession> ARMS_DEALER_PROFESSION = VillagerRegistry.registerProfession("arms_dealer", ARMS_DEALER_POI);
    private static final ResourceLocation ARMS_DEALER_BARN_RESOURCE = new ResourceLocation("pointblank", "village/all_terrain/arms_dealer_barn");
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));
    private static final ResourceLocation[] HOUSES_RESOURCES = new ResourceLocation[]{new ResourceLocation("minecraft", "village/plains/houses"), new ResourceLocation("minecraft", "village/desert/houses"), new ResourceLocation("minecraft", "village/savanna/houses"), new ResourceLocation("minecraft", "village/snowy/houses"), new ResourceLocation("minecraft", "village/taiga/houses")};

    private static Set<BlockState> getBlockStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_());
    }

    private static RegistryObject<PoiType> registerPoiType(String name, Supplier<Block> block, int maxTickets, int validRange) {
        return POI_TYPES.register(name, () -> new PoiType(VillagerRegistry.getBlockStates((Block)block.get()), maxTickets, validRange));
    }

    private static RegistryObject<VillagerProfession> registerProfession(String name, RegistryObject<PoiType> poiHolder) {
        return PROFESSIONS.register(name, () -> new VillagerProfession(name, holder -> holder.m_203565_(poiHolder.getKey()), holder -> holder.m_203565_(poiHolder.getKey()), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12565_));
    }

    public static void registerStructures(MinecraftServer server) {
        Registry templatePoolRegistry = (Registry)server.m_206579_().m_6632_(Registries.f_256948_).orElseThrow();
        Registry processorListRegistry = (Registry)server.m_206579_().m_6632_(Registries.f_257011_).orElseThrow();
        for (ResourceLocation poolLocation : HOUSES_RESOURCES) {
            VillagerRegistry.registerStructure((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, poolLocation, ARMS_DEALER_BARN_RESOURCE, Config.armsDealerHouseWeight);
        }
    }

    public static void registerStructure(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation targetPoolResource, ResourceLocation structureResource, int weight) {
        if (weight == 0) {
            return;
        }
        Holder.Reference emptyProcessorList = processorListRegistry.m_246971_(EMPTY_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(targetPoolResource);
        if (pool == null) {
            return;
        }
        SinglePoolElement structurePoolElement = (SinglePoolElement)SinglePoolElement.m_210531_((String)structureResource.toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            ((StructureTemplatePoolMixin)pool).getTemplates().add((Object)structurePoolElement);
        }
        ArrayList<Pair<StructurePoolElement, Integer>> rawTemplates = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructureTemplatePoolMixin)pool).getRawTemplates());
        rawTemplates.add((Pair<StructurePoolElement, Integer>)new Pair((Object)structurePoolElement, (Object)weight));
        ((StructureTemplatePoolMixin)pool).setRawTemplates(rawTemplates);
    }
}

