/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mekanism.client.model.ModelPartData;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public abstract class MekanismJavaModel
extends Model {
    public MekanismJavaModel(Function<ResourceLocation, RenderType> renderType) {
        super(renderType);
    }

    protected static VertexConsumer getVertexConsumer(@NotNull MultiBufferSource renderer, @NotNull RenderType renderType, boolean hasEffect) {
        return ItemRenderer.m_115222_((MultiBufferSource)renderer, (RenderType)renderType, (boolean)false, (boolean)hasEffect);
    }

    protected static void setRotation(ModelPart model, float x, float y, float z) {
        model.f_104203_ = x;
        model.f_104204_ = y;
        model.f_104205_ = z;
    }

    protected static void renderPartsToBuffer(List<ModelPart> parts, PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int light, int overlayLight, float red, float green, float blue, float alpha) {
        for (ModelPart part : parts) {
            part.m_104306_(poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha);
        }
    }

    protected static List<ModelPart> getRenderableParts(ModelPart root, ModelPartData ... modelPartData) {
        ArrayList<ModelPart> parts = new ArrayList<ModelPart>(modelPartData.length);
        for (ModelPartData partData : modelPartData) {
            parts.add(partData.getFromRoot(root));
        }
        return parts;
    }

    protected static LayerDefinition createLayerDefinition(int textureWidth, int textureHeight, ModelPartData ... parts) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        for (ModelPartData part : parts) {
            part.addToDefinition(partdefinition);
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)textureWidth, (int)textureHeight);
    }

    protected static void renderPartsAsWireFrame(List<ModelPart> parts, PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int red, int green, int blue, int alpha) {
        for (ModelPart part : parts) {
            MekanismJavaModel.renderWireFrame(part, poseStack, vertexConsumer, red, green, blue, alpha);
        }
    }

    public static void renderWireFrame(ModelPart part, PoseStack matrix, VertexConsumer vertexConsumer, int red, int green, int blue, int alpha) {
        if (part.f_104207_) {
            part.m_171309_(matrix, (pose, name, cubeIndex, cube) -> {
                Matrix4f matrix4f = pose.m_252922_();
                for (ModelPart.Polygon quad : cube.f_104341_) {
                    Vector3f normal = new Vector3f((Vector3fc)quad.f_104360_);
                    normal.mul((Matrix3fc)pose.m_252943_());
                    float normalX = normal.x();
                    float normalY = normal.y();
                    float normalZ = normal.z();
                    Vector4f vertex = MekanismJavaModel.getVertex(matrix4f, quad.f_104359_[0]);
                    Vector4f vertex2 = MekanismJavaModel.getVertex(matrix4f, quad.f_104359_[1]);
                    Vector4f vertex3 = MekanismJavaModel.getVertex(matrix4f, quad.f_104359_[2]);
                    Vector4f vertex4 = MekanismJavaModel.getVertex(matrix4f, quad.f_104359_[3]);
                    vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex2.x(), (double)vertex2.y(), (double)vertex2.z()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex3.x(), (double)vertex3.y(), (double)vertex3.z()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex4.x(), (double)vertex4.y(), (double)vertex4.z()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex2.x(), (double)vertex2.y(), (double)vertex2.z()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex3.x(), (double)vertex3.y(), (double)vertex3.z()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex.x(), (double)vertex.y(), (double)vertex.z()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                    vertexConsumer.m_5483_((double)vertex4.x(), (double)vertex4.y(), (double)vertex4.z()).m_6122_(red, green, blue, alpha).m_5601_(normalX, normalY, normalZ).m_5752_();
                }
            });
        }
    }

    private static Vector4f getVertex(Matrix4f matrix4f, ModelPart.Vertex vertex) {
        Vector4f vector4f = new Vector4f(vertex.f_104371_.x() / 16.0f, vertex.f_104371_.y() / 16.0f, vertex.f_104371_.z() / 16.0f, 1.0f);
        return vector4f.mul((Matrix4fc)matrix4f);
    }
}

