/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.Iterator;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleBooleanData;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.distribution.EnergySaveTarget;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNotNullByDefault
public class ModuleChargeDistributionUnit
implements ICustomModule<ModuleChargeDistributionUnit> {
    private IModuleConfigItem<Boolean> chargeSuit;
    private IModuleConfigItem<Boolean> chargeInventory;

    @Override
    public void init(IModule<ModuleChargeDistributionUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.chargeSuit = configItemCreator.createConfigItem("charge_suit", MekanismLang.MODULE_CHARGE_SUIT, new ModuleBooleanData());
        this.chargeInventory = configItemCreator.createConfigItem("charge_inventory", MekanismLang.MODULE_CHARGE_INVENTORY, new ModuleBooleanData(false));
    }

    @Override
    public void tickServer(IModule<ModuleChargeDistributionUnit> module, Player player) {
        if (this.chargeInventory.get().booleanValue()) {
            this.chargeInventory(module, player);
        }
        if (this.chargeSuit.get().booleanValue()) {
            this.chargeSuit(player);
        }
    }

    private void chargeSuit(Player player) {
        FloatingLong total = FloatingLong.ZERO;
        EnergySaveTarget saveTarget = new EnergySaveTarget(4);
        for (ItemStack stack : player.m_6168_()) {
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
            if (energyContainer == null) continue;
            saveTarget.addDelegate(energyContainer);
            total = total.plusEqual(energyContainer.getEnergy());
        }
        EmitUtils.sendToAcceptors(saveTarget, total);
        saveTarget.save();
    }

    private void chargeInventory(IModule<ModuleChargeDistributionUnit> module, Player player) {
        FloatingLong toCharge = (FloatingLong)MekanismConfig.gear.mekaSuitInventoryChargeRate.get();
        toCharge = this.charge(module, player, player.m_21205_(), toCharge);
        toCharge = this.charge(module, player, player.m_21206_(), toCharge);
        if (!toCharge.isZero()) {
            Optional<? extends IItemHandler> curiosInventory;
            ItemStack stack;
            Iterator iterator = player.m_150109_().f_35974_.iterator();
            while (iterator.hasNext() && ((stack = (ItemStack)iterator.next()) == player.m_21205_() || stack == player.m_21206_() || !(toCharge = this.charge(module, player, stack, toCharge)).isZero())) {
            }
            if (!toCharge.isZero() && Mekanism.hooks.CuriosLoaded && (curiosInventory = CuriosIntegration.getCuriosInventory((LivingEntity)player)).isPresent()) {
                IItemHandler handler = curiosInventory.get();
                int slots = handler.getSlots();
                for (int slot = 0; slot < slots && !(toCharge = this.charge(module, player, handler.getStackInSlot(slot), toCharge)).isZero(); ++slot) {
                }
            }
        }
    }

    private FloatingLong charge(IModule<ModuleChargeDistributionUnit> module, Player player, ItemStack stack, FloatingLong amount) {
        FloatingLong remaining;
        IStrictEnergyHandler handler;
        if (!stack.m_41619_() && !amount.isZero() && (handler = EnergyCompatUtils.getStrictEnergyHandler(stack)) != null && (remaining = handler.insertEnergy(amount, Action.SIMULATE)).smallerThan(amount)) {
            return handler.insertEnergy(module.useEnergy((LivingEntity)player, amount.subtract(remaining), false), Action.EXECUTE).add(remaining);
        }
        return amount;
    }
}

