/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.integration.projecte.NSSGas;
import mekanism.common.integration.projecte.NSSInfuseType;
import mekanism.common.integration.projecte.NSSPigment;
import mekanism.common.integration.projecte.NSSSlurry;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class IngredientHelper {
    private final IMappingCollector<NormalizedSimpleStack, Long> mapper;
    private Map<NormalizedSimpleStack, Integer> ingredientMap = new HashMap<NormalizedSimpleStack, Integer>();
    private boolean isValid = true;

    public IngredientHelper(IMappingCollector<NormalizedSimpleStack, Long> mapper) {
        this.mapper = mapper;
    }

    public void resetHelper() {
        this.isValid = true;
        this.ingredientMap = new HashMap<NormalizedSimpleStack, Integer>();
    }

    public void put(NormalizedSimpleStack stack, int amount) {
        if (this.isValid) {
            if (this.ingredientMap.containsKey(stack)) {
                long newAmount = (long)this.ingredientMap.get(stack).intValue() + (long)amount;
                if (newAmount > Integer.MAX_VALUE || newAmount < Integer.MIN_VALUE) {
                    this.isValid = false;
                } else {
                    this.ingredientMap.put(stack, (int)newAmount);
                }
            } else {
                this.ingredientMap.put(stack, amount);
            }
        }
    }

    public void put(NormalizedSimpleStack stack, long amount) {
        if (amount > Integer.MAX_VALUE || amount < Integer.MIN_VALUE) {
            this.isValid = false;
        } else {
            this.put(stack, (int)amount);
        }
    }

    public void put(ChemicalStack<?> chemicalStack) {
        if (chemicalStack instanceof GasStack) {
            GasStack stack = (GasStack)chemicalStack;
            this.put(stack);
        } else if (chemicalStack instanceof InfusionStack) {
            InfusionStack stack = (InfusionStack)chemicalStack;
            this.put(stack);
        } else if (chemicalStack instanceof PigmentStack) {
            PigmentStack stack = (PigmentStack)chemicalStack;
            this.put(stack);
        } else if (chemicalStack instanceof SlurryStack) {
            SlurryStack stack = (SlurryStack)chemicalStack;
            this.put(stack);
        }
    }

    public void put(GasStack stack) {
        this.put((NormalizedSimpleStack)NSSGas.createGas(stack), stack.getAmount());
    }

    public void put(InfusionStack stack) {
        this.put((NormalizedSimpleStack)NSSInfuseType.createInfuseType(stack), stack.getAmount());
    }

    public void put(PigmentStack stack) {
        this.put((NormalizedSimpleStack)NSSPigment.createPigment(stack), stack.getAmount());
    }

    public void put(SlurryStack stack) {
        this.put((NormalizedSimpleStack)NSSSlurry.createSlurry(stack), stack.getAmount());
    }

    public void put(FluidStack stack) {
        this.put((NormalizedSimpleStack)NSSFluid.createFluid((FluidStack)stack), stack.getAmount());
    }

    public void put(ItemStack stack) {
        this.put((NormalizedSimpleStack)NSSItem.createItem((ItemStack)stack), stack.m_41613_());
    }

    public boolean addAsConversion(NormalizedSimpleStack output, int outputAmount) {
        if (this.isValid) {
            this.mapper.addConversion(outputAmount, (Object)output, this.ingredientMap);
            return true;
        }
        return false;
    }

    public boolean addAsConversion(NormalizedSimpleStack output, long outputAmount) {
        if (outputAmount > Integer.MAX_VALUE) {
            return false;
        }
        return this.addAsConversion(output, (int)outputAmount);
    }

    public boolean addAsConversion(ChemicalStack<?> chemicalStack) {
        if (chemicalStack instanceof GasStack) {
            GasStack stack = (GasStack)chemicalStack;
            return this.addAsConversion(stack);
        }
        if (chemicalStack instanceof InfusionStack) {
            InfusionStack stack = (InfusionStack)chemicalStack;
            return this.addAsConversion(stack);
        }
        if (chemicalStack instanceof PigmentStack) {
            PigmentStack stack = (PigmentStack)chemicalStack;
            return this.addAsConversion(stack);
        }
        if (chemicalStack instanceof SlurryStack) {
            SlurryStack stack = (SlurryStack)chemicalStack;
            return this.addAsConversion(stack);
        }
        return false;
    }

    public boolean addAsConversion(GasStack stack) {
        return this.addAsConversion((NormalizedSimpleStack)NSSGas.createGas(stack), stack.getAmount());
    }

    public boolean addAsConversion(InfusionStack stack) {
        return this.addAsConversion((NormalizedSimpleStack)NSSInfuseType.createInfuseType(stack), stack.getAmount());
    }

    public boolean addAsConversion(PigmentStack stack) {
        return this.addAsConversion((NormalizedSimpleStack)NSSPigment.createPigment(stack), stack.getAmount());
    }

    public boolean addAsConversion(SlurryStack stack) {
        return this.addAsConversion((NormalizedSimpleStack)NSSSlurry.createSlurry(stack), stack.getAmount());
    }

    public boolean addAsConversion(FluidStack stack) {
        return this.addAsConversion((NormalizedSimpleStack)NSSFluid.createFluid((FluidStack)stack), stack.getAmount());
    }

    public boolean addAsConversion(ItemStack stack) {
        return this.addAsConversion((NormalizedSimpleStack)NSSItem.createItem((ItemStack)stack), stack.m_41613_());
    }
}

