/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.chemical;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IEmptyGasProvider;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.chemical.SyncableChemicalStack;
import mekanism.common.network.to_client.container.property.LongPropertyData;
import mekanism.common.network.to_client.container.property.PropertyData;
import mekanism.common.network.to_client.container.property.chemical.GasStackPropertyData;
import org.jetbrains.annotations.NotNull;

public class SyncableGasStack
extends SyncableChemicalStack<Gas, GasStack>
implements IEmptyGasProvider {
    public static SyncableGasStack create(IGasTank handler) {
        return SyncableGasStack.create(handler, false);
    }

    public static SyncableGasStack create(IGasTank handler, boolean isClient) {
        return SyncableGasStack.create(handler::getStack, isClient ? handler::setStackUnchecked : handler::setStack);
    }

    public static SyncableGasStack create(Supplier<@NotNull GasStack> getter, Consumer<@NotNull GasStack> setter) {
        return new SyncableGasStack(getter, setter);
    }

    private SyncableGasStack(Supplier<@NotNull GasStack> getter, Consumer<@NotNull GasStack> setter) {
        super(getter, setter);
    }

    @Override
    @NotNull
    protected GasStack createStack(GasStack stored, long size) {
        return new GasStack(stored, size);
    }

    @Override
    public PropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        if (dirtyType == ISyncableData.DirtyType.SIZE) {
            return new LongPropertyData(property, ((GasStack)this.get()).getAmount());
        }
        return new GasStackPropertyData(property, (GasStack)this.get());
    }
}

