/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib;

import net.minecraftforge.fml.ModContainer;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class Version {
    public int major;
    public int minor;
    public int build;

    public Version(int majorNum, int minorNum, int buildNum) {
        this.major = majorNum;
        this.minor = minorNum;
        this.build = buildNum;
    }

    public Version(ArtifactVersion artifactVersion) {
        this(artifactVersion.getMajorVersion(), artifactVersion.getMinorVersion(), artifactVersion.getIncrementalVersion());
    }

    public Version(ModContainer container) {
        this(container.getModInfo().getVersion());
    }

    public static Version get(String s) {
        String[] split = s.replace('.', ':').split(":");
        if (split.length != 3) {
            return null;
        }
        int[] digits = new int[3];
        for (int i = 0; i < digits.length; ++i) {
            try {
                digits[i] = Integer.parseInt(split[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return new Version(digits[0], digits[1], digits[2]);
    }

    public void reset() {
        this.major = 0;
        this.minor = 0;
        this.build = 0;
    }

    public byte comparedState(Version version) {
        if (version.major > this.major) {
            return -1;
        }
        if (version.major == this.major) {
            if (version.minor > this.minor) {
                return -1;
            }
            if (version.minor == this.minor) {
                return (byte)Integer.compare(this.build, version.build);
            }
            return 1;
        }
        return 1;
    }

    public String toString() {
        if (this.major == 0 && this.minor == 0 && this.build == 0) {
            return "";
        }
        return this.major + "." + this.minor + "." + this.build;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.build;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return this.build == other.build && this.major == other.major && this.minor == other.minor;
    }
}

